@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin

import com.pulumi.azurenative.databoxedge.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.databoxedge.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [StorageAccount].
 */
@PulumiTagMarker
public class StorageAccountResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: StorageAccountArgs = StorageAccountArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend StorageAccountArgsBuilder.() -> Unit) {
        val builder = StorageAccountArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): StorageAccount {
        val builtJavaResource =
            com.pulumi.azurenative.databoxedge.StorageAccount(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return StorageAccount(builtJavaResource)
    }
}

/**
 * Represents a Storage Account on the  Data Box Edge/Gateway device.
 * Azure REST API version: 2022-03-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2020-05-01-preview, 2023-01-01-preview, 2023-07-01.
 * ## Example Usage
 * ### StorageAccountPut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var storageAccount = new AzureNative.DataBoxEdge.StorageAccount("storageAccount", new()
 *     {
 *         DataPolicy = "Cloud",
 *         Description = "It's an awesome storage account",
 *         DeviceName = "testedgedevice",
 *         ResourceGroupName = "GroupForEdgeAutomation",
 *         StorageAccountCredentialId = "/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/GroupForDataBoxEdgeAutomation/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/testedgedevice/storageAccountCredentials/cisbvt",
 *         StorageAccountName = "blobstorageaccount1",
 *         StorageAccountStatus = "OK",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/databoxedge/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := databoxedge.NewStorageAccount(ctx, "storageAccount", &databoxedge.StorageAccountArgs{
 * 			DataPolicy:                 pulumi.String("Cloud"),
 * 			Description:                pulumi.String("It's an awesome storage account"),
 * 			DeviceName:                 pulumi.String("testedgedevice"),
 * 			ResourceGroupName:          pulumi.String("GroupForEdgeAutomation"),
 * 			StorageAccountCredentialId: pulumi.String("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/GroupForDataBoxEdgeAutomation/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/testedgedevice/storageAccountCredentials/cisbvt"),
 * 			StorageAccountName:         pulumi.String("blobstorageaccount1"),
 * 			StorageAccountStatus:       pulumi.String("OK"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.databoxedge.StorageAccount;
 * import com.pulumi.azurenative.databoxedge.StorageAccountArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var storageAccount = new StorageAccount("storageAccount", StorageAccountArgs.builder()
 *             .dataPolicy("Cloud")
 *             .description("It's an awesome storage account")
 *             .deviceName("testedgedevice")
 *             .resourceGroupName("GroupForEdgeAutomation")
 *             .storageAccountCredentialId("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/GroupForDataBoxEdgeAutomation/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/testedgedevice/storageAccountCredentials/cisbvt")
 *             .storageAccountName("blobstorageaccount1")
 *             .storageAccountStatus("OK")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:databoxedge:StorageAccount blobstorageaccount1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/{deviceName}/storageAccounts/{storageAccountName}
 * ```
 */
public class StorageAccount internal constructor(
    override val javaResource: com.pulumi.azurenative.databoxedge.StorageAccount,
) : KotlinCustomResource(javaResource, StorageAccountMapper) {
    /**
     * BlobEndpoint of Storage Account
     */
    public val blobEndpoint: Output<String>
        get() = javaResource.blobEndpoint().applyValue({ args0 -> args0 })

    /**
     * The Container Count. Present only for Storage Accounts with DataPolicy set to Cloud.
     */
    public val containerCount: Output<Int>
        get() = javaResource.containerCount().applyValue({ args0 -> args0 })

    /**
     * Data policy of the storage Account.
     */
    public val dataPolicy: Output<String>
        get() = javaResource.dataPolicy().applyValue({ args0 -> args0 })

    /**
     * Description for the storage Account.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The object name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Storage Account Credential Id
     */
    public val storageAccountCredentialId: Output<String>?
        get() = javaResource.storageAccountCredentialId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Current status of the storage account
     */
    public val storageAccountStatus: Output<String>?
        get() = javaResource.storageAccountStatus().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Metadata pertaining to creation and last modification of StorageAccount
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The hierarchical type of the object.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object StorageAccountMapper : ResourceMapper<StorageAccount> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.databoxedge.StorageAccount::class == javaResource::class

    override fun map(javaResource: Resource): StorageAccount = StorageAccount(
        javaResource as
            com.pulumi.azurenative.databoxedge.StorageAccount,
    )
}

/**
 * @see [StorageAccount].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [StorageAccount].
 */
public suspend fun storageAccount(
    name: String,
    block: suspend StorageAccountResourceBuilder.() -> Unit,
): StorageAccount {
    val builder = StorageAccountResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [StorageAccount].
 * @param name The _unique_ name of the resulting resource.
 */
public fun storageAccount(name: String): StorageAccount {
    val builder = StorageAccountResourceBuilder()
    builder.name(name)
    return builder.build()
}
