@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin.inputs

import com.pulumi.azurenative.databoxedge.inputs.AddressArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The shipping address of the customer.
 * @property addressLine1 The address line1.
 * @property addressLine2 The address line2.
 * @property addressLine3 The address line3.
 * @property city The city name.
 * @property country The country name.
 * @property postalCode The postal code.
 * @property state The state name.
 */
public data class AddressArgs(
    public val addressLine1: Output<String>? = null,
    public val addressLine2: Output<String>? = null,
    public val addressLine3: Output<String>? = null,
    public val city: Output<String>? = null,
    public val country: Output<String>,
    public val postalCode: Output<String>? = null,
    public val state: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.databoxedge.inputs.AddressArgs> {
    override fun toJava(): com.pulumi.azurenative.databoxedge.inputs.AddressArgs =
        com.pulumi.azurenative.databoxedge.inputs.AddressArgs.builder()
            .addressLine1(addressLine1?.applyValue({ args0 -> args0 }))
            .addressLine2(addressLine2?.applyValue({ args0 -> args0 }))
            .addressLine3(addressLine3?.applyValue({ args0 -> args0 }))
            .city(city?.applyValue({ args0 -> args0 }))
            .country(country.applyValue({ args0 -> args0 }))
            .postalCode(postalCode?.applyValue({ args0 -> args0 }))
            .state(state?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AddressArgs].
 */
@PulumiTagMarker
public class AddressArgsBuilder internal constructor() {
    private var addressLine1: Output<String>? = null

    private var addressLine2: Output<String>? = null

    private var addressLine3: Output<String>? = null

    private var city: Output<String>? = null

    private var country: Output<String>? = null

    private var postalCode: Output<String>? = null

    private var state: Output<String>? = null

    /**
     * @param value The address line1.
     */
    @JvmName("pdsyhxexhxgfyjrx")
    public suspend fun addressLine1(`value`: Output<String>) {
        this.addressLine1 = value
    }

    /**
     * @param value The address line2.
     */
    @JvmName("avjilnulfncaoaei")
    public suspend fun addressLine2(`value`: Output<String>) {
        this.addressLine2 = value
    }

    /**
     * @param value The address line3.
     */
    @JvmName("bcvmovbyegjquyvn")
    public suspend fun addressLine3(`value`: Output<String>) {
        this.addressLine3 = value
    }

    /**
     * @param value The city name.
     */
    @JvmName("fkxaikpuwpsocpgq")
    public suspend fun city(`value`: Output<String>) {
        this.city = value
    }

    /**
     * @param value The country name.
     */
    @JvmName("jmrqiwbcfixkfusm")
    public suspend fun country(`value`: Output<String>) {
        this.country = value
    }

    /**
     * @param value The postal code.
     */
    @JvmName("gwchllttbhhtvwgb")
    public suspend fun postalCode(`value`: Output<String>) {
        this.postalCode = value
    }

    /**
     * @param value The state name.
     */
    @JvmName("tuyclbcvldgqpbtg")
    public suspend fun state(`value`: Output<String>) {
        this.state = value
    }

    /**
     * @param value The address line1.
     */
    @JvmName("cqbdtsabhuawufvp")
    public suspend fun addressLine1(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addressLine1 = mapped
    }

    /**
     * @param value The address line2.
     */
    @JvmName("xfwcuqxgdsoedcvn")
    public suspend fun addressLine2(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addressLine2 = mapped
    }

    /**
     * @param value The address line3.
     */
    @JvmName("mmjvuumughaccxhk")
    public suspend fun addressLine3(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addressLine3 = mapped
    }

    /**
     * @param value The city name.
     */
    @JvmName("dkuyeasejgmvwciu")
    public suspend fun city(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.city = mapped
    }

    /**
     * @param value The country name.
     */
    @JvmName("jlnsqexobcnxmelu")
    public suspend fun country(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.country = mapped
    }

    /**
     * @param value The postal code.
     */
    @JvmName("vgujivfansmpfybw")
    public suspend fun postalCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.postalCode = mapped
    }

    /**
     * @param value The state name.
     */
    @JvmName("hmjcwpwgjflhsixp")
    public suspend fun state(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    internal fun build(): AddressArgs = AddressArgs(
        addressLine1 = addressLine1,
        addressLine2 = addressLine2,
        addressLine3 = addressLine3,
        city = city,
        country = country ?: throw PulumiNullFieldException("country"),
        postalCode = postalCode,
        state = state,
    )
}
