@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin.inputs

import com.pulumi.azurenative.databoxedge.inputs.DataResidencyArgs.builder
import com.pulumi.azurenative.databoxedge.kotlin.enums.DataResidencyType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Wraps data-residency related information for edge-resource and this should be used with ARM layer.
 * @property type DataResidencyType enum
 */
public data class DataResidencyArgs(
    public val type: Output<Either<String, DataResidencyType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.databoxedge.inputs.DataResidencyArgs> {
    override fun toJava(): com.pulumi.azurenative.databoxedge.inputs.DataResidencyArgs =
        com.pulumi.azurenative.databoxedge.inputs.DataResidencyArgs.builder()
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [DataResidencyArgs].
 */
@PulumiTagMarker
public class DataResidencyArgsBuilder internal constructor() {
    private var type: Output<Either<String, DataResidencyType>>? = null

    /**
     * @param value DataResidencyType enum
     */
    @JvmName("mssisndmlhasjivt")
    public suspend fun type(`value`: Output<Either<String, DataResidencyType>>) {
        this.type = value
    }

    /**
     * @param value DataResidencyType enum
     */
    @JvmName("tjriivjyknjtnbbg")
    public suspend fun type(`value`: Either<String, DataResidencyType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value DataResidencyType enum
     */
    @JvmName("jmpnxfvagvvxixfd")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DataResidencyType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value DataResidencyType enum
     */
    @JvmName("cdwwukswuouowuni")
    public fun type(`value`: DataResidencyType) {
        val toBeMapped = Either.ofRight<String, DataResidencyType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): DataResidencyArgs = DataResidencyArgs(
        type = type,
    )
}
