@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin.inputs

import com.pulumi.azurenative.databoxedge.inputs.GetBandwidthSchedulePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property deviceName The device name.
 * @property name The bandwidth schedule name.
 * @property resourceGroupName The resource group name.
 */
public data class GetBandwidthSchedulePlainArgs(
    public val deviceName: String,
    public val name: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.databoxedge.inputs.GetBandwidthSchedulePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.databoxedge.inputs.GetBandwidthSchedulePlainArgs =
        com.pulumi.azurenative.databoxedge.inputs.GetBandwidthSchedulePlainArgs.builder()
            .deviceName(deviceName.let({ args0 -> args0 }))
            .name(name.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetBandwidthSchedulePlainArgs].
 */
@PulumiTagMarker
public class GetBandwidthSchedulePlainArgsBuilder internal constructor() {
    private var deviceName: String? = null

    private var name: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The device name.
     */
    @JvmName("uxqtmspwpgenhfjr")
    public suspend fun deviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.deviceName = mapped
    }

    /**
     * @param value The bandwidth schedule name.
     */
    @JvmName("fmnwdrwmiuiwgera")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("kihohguyceuufiyu")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetBandwidthSchedulePlainArgs = GetBandwidthSchedulePlainArgs(
        deviceName = deviceName ?: throw PulumiNullFieldException("deviceName"),
        name = name ?: throw PulumiNullFieldException("name"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
