@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin.inputs

import com.pulumi.azurenative.databoxedge.inputs.GetContainerPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property containerName The container Name
 * @property deviceName The device name.
 * @property resourceGroupName The resource group name.
 * @property storageAccountName The Storage Account Name
 */
public data class GetContainerPlainArgs(
    public val containerName: String,
    public val deviceName: String,
    public val resourceGroupName: String,
    public val storageAccountName: String,
) : ConvertibleToJava<com.pulumi.azurenative.databoxedge.inputs.GetContainerPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.databoxedge.inputs.GetContainerPlainArgs =
        com.pulumi.azurenative.databoxedge.inputs.GetContainerPlainArgs.builder()
            .containerName(containerName.let({ args0 -> args0 }))
            .deviceName(deviceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .storageAccountName(storageAccountName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetContainerPlainArgs].
 */
@PulumiTagMarker
public class GetContainerPlainArgsBuilder internal constructor() {
    private var containerName: String? = null

    private var deviceName: String? = null

    private var resourceGroupName: String? = null

    private var storageAccountName: String? = null

    /**
     * @param value The container Name
     */
    @JvmName("hykflrmgtbvxjjni")
    public suspend fun containerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.containerName = mapped
    }

    /**
     * @param value The device name.
     */
    @JvmName("jjodmktrieswagcw")
    public suspend fun deviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.deviceName = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("xwuoprmgvvfpfogv")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The Storage Account Name
     */
    @JvmName("mnkptbfkxqjiblcd")
    public suspend fun storageAccountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.storageAccountName = mapped
    }

    internal fun build(): GetContainerPlainArgs = GetContainerPlainArgs(
        containerName = containerName ?: throw PulumiNullFieldException("containerName"),
        deviceName = deviceName ?: throw PulumiNullFieldException("deviceName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        storageAccountName = storageAccountName ?: throw PulumiNullFieldException("storageAccountName"),
    )
}
