@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin.inputs

import com.pulumi.azurenative.databoxedge.inputs.MetricCounterSetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The metric counter set
 * @property counters The counters that should be collected in this set.
 */
public data class MetricCounterSetArgs(
    public val counters: Output<List<MetricCounterArgs>>,
) : ConvertibleToJava<com.pulumi.azurenative.databoxedge.inputs.MetricCounterSetArgs> {
    override fun toJava(): com.pulumi.azurenative.databoxedge.inputs.MetricCounterSetArgs =
        com.pulumi.azurenative.databoxedge.inputs.MetricCounterSetArgs.builder()
            .counters(
                counters.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [MetricCounterSetArgs].
 */
@PulumiTagMarker
public class MetricCounterSetArgsBuilder internal constructor() {
    private var counters: Output<List<MetricCounterArgs>>? = null

    /**
     * @param value The counters that should be collected in this set.
     */
    @JvmName("rgppguwqsmajyeon")
    public suspend fun counters(`value`: Output<List<MetricCounterArgs>>) {
        this.counters = value
    }

    @JvmName("lrdflaygcboliudo")
    public suspend fun counters(vararg values: Output<MetricCounterArgs>) {
        this.counters = Output.all(values.asList())
    }

    /**
     * @param values The counters that should be collected in this set.
     */
    @JvmName("rlwuyyfqcugcnjrb")
    public suspend fun counters(values: List<Output<MetricCounterArgs>>) {
        this.counters = Output.all(values)
    }

    /**
     * @param value The counters that should be collected in this set.
     */
    @JvmName("kpmcashdmlqdbykm")
    public suspend fun counters(`value`: List<MetricCounterArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.counters = mapped
    }

    /**
     * @param argument The counters that should be collected in this set.
     */
    @JvmName("utvikpkfedmnqkpd")
    public suspend fun counters(argument: List<suspend MetricCounterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            MetricCounterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.counters = mapped
    }

    /**
     * @param argument The counters that should be collected in this set.
     */
    @JvmName("iwdjapcsvxjodwwo")
    public suspend fun counters(vararg argument: suspend MetricCounterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            MetricCounterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.counters = mapped
    }

    /**
     * @param argument The counters that should be collected in this set.
     */
    @JvmName("ewrbruquykpicqjr")
    public suspend fun counters(argument: suspend MetricCounterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(MetricCounterArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.counters = mapped
    }

    /**
     * @param values The counters that should be collected in this set.
     */
    @JvmName("scuiujwpmohmagbl")
    public suspend fun counters(vararg values: MetricCounterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.counters = mapped
    }

    internal fun build(): MetricCounterSetArgs = MetricCounterSetArgs(
        counters = counters ?: throw PulumiNullFieldException("counters"),
    )
}
