@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin.inputs

import com.pulumi.azurenative.databoxedge.inputs.MountPointMapArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The share mount point.
 * @property shareId ID of the share mounted to the role VM.
 */
public data class MountPointMapArgs(
    public val shareId: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.databoxedge.inputs.MountPointMapArgs> {
    override fun toJava(): com.pulumi.azurenative.databoxedge.inputs.MountPointMapArgs =
        com.pulumi.azurenative.databoxedge.inputs.MountPointMapArgs.builder()
            .shareId(shareId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MountPointMapArgs].
 */
@PulumiTagMarker
public class MountPointMapArgsBuilder internal constructor() {
    private var shareId: Output<String>? = null

    /**
     * @param value ID of the share mounted to the role VM.
     */
    @JvmName("vpkuahointxohmwh")
    public suspend fun shareId(`value`: Output<String>) {
        this.shareId = value
    }

    /**
     * @param value ID of the share mounted to the role VM.
     */
    @JvmName("mjaxgmvyhwvxjeqo")
    public suspend fun shareId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.shareId = mapped
    }

    internal fun build(): MountPointMapArgs = MountPointMapArgs(
        shareId = shareId ?: throw PulumiNullFieldException("shareId"),
    )
}
