@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin.inputs

import com.pulumi.azurenative.databoxedge.inputs.UserAccessRightArgs.builder
import com.pulumi.azurenative.databoxedge.kotlin.enums.ShareAccessType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The mapping between a particular user and the access type on the SMB share.
 * @property accessType Type of access to be allowed for the user.
 * @property userId User ID (already existing in the device).
 */
public data class UserAccessRightArgs(
    public val accessType: Output<Either<String, ShareAccessType>>,
    public val userId: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.databoxedge.inputs.UserAccessRightArgs> {
    override fun toJava(): com.pulumi.azurenative.databoxedge.inputs.UserAccessRightArgs =
        com.pulumi.azurenative.databoxedge.inputs.UserAccessRightArgs.builder()
            .accessType(
                accessType.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .userId(userId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserAccessRightArgs].
 */
@PulumiTagMarker
public class UserAccessRightArgsBuilder internal constructor() {
    private var accessType: Output<Either<String, ShareAccessType>>? = null

    private var userId: Output<String>? = null

    /**
     * @param value Type of access to be allowed for the user.
     */
    @JvmName("mkbuovywbatouepq")
    public suspend fun accessType(`value`: Output<Either<String, ShareAccessType>>) {
        this.accessType = value
    }

    /**
     * @param value User ID (already existing in the device).
     */
    @JvmName("gsbhhdxnfegptwir")
    public suspend fun userId(`value`: Output<String>) {
        this.userId = value
    }

    /**
     * @param value Type of access to be allowed for the user.
     */
    @JvmName("ijxwcinpvdyahafu")
    public suspend fun accessType(`value`: Either<String, ShareAccessType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accessType = mapped
    }

    /**
     * @param value Type of access to be allowed for the user.
     */
    @JvmName("fooipkavmmeofubl")
    public fun accessType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ShareAccessType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accessType = mapped
    }

    /**
     * @param value Type of access to be allowed for the user.
     */
    @JvmName("ecgdpiohmhdypjrh")
    public fun accessType(`value`: ShareAccessType) {
        val toBeMapped = Either.ofRight<String, ShareAccessType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accessType = mapped
    }

    /**
     * @param value User ID (already existing in the device).
     */
    @JvmName("dwlsfobigfeqlbxw")
    public suspend fun userId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userId = mapped
    }

    internal fun build(): UserAccessRightArgs = UserAccessRightArgs(
        accessType = accessType ?: throw PulumiNullFieldException("accessType"),
        userId = userId ?: throw PulumiNullFieldException("userId"),
    )
}
