@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The shipping address of the customer.
 * @property addressLine1 The address line1.
 * @property addressLine2 The address line2.
 * @property addressLine3 The address line3.
 * @property city The city name.
 * @property country The country name.
 * @property postalCode The postal code.
 * @property state The state name.
 */
public data class AddressResponse(
    public val addressLine1: String? = null,
    public val addressLine2: String? = null,
    public val addressLine3: String? = null,
    public val city: String? = null,
    public val country: String,
    public val postalCode: String? = null,
    public val state: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databoxedge.outputs.AddressResponse):
            AddressResponse = AddressResponse(
            addressLine1 = javaType.addressLine1().map({ args0 -> args0 }).orElse(null),
            addressLine2 = javaType.addressLine2().map({ args0 -> args0 }).orElse(null),
            addressLine3 = javaType.addressLine3().map({ args0 -> args0 }).orElse(null),
            city = javaType.city().map({ args0 -> args0 }).orElse(null),
            country = javaType.country(),
            postalCode = javaType.postalCode().map({ args0 -> args0 }).orElse(null),
            state = javaType.state().map({ args0 -> args0 }).orElse(null),
        )
    }
}
