@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Subscription details for the Edge Profile
 * @property id ARM ID of the subscription
 * @property locationPlacementId
 * @property quotaId
 * @property registeredFeatures
 * @property registrationDate
 * @property registrationId Edge Subscription Registration ID
 * @property serializedDetails
 * @property state
 * @property subscriptionId
 * @property tenantId
 */
public data class EdgeProfileSubscriptionResponse(
    public val id: String? = null,
    public val locationPlacementId: String? = null,
    public val quotaId: String? = null,
    public val registeredFeatures: List<SubscriptionRegisteredFeaturesResponse>? = null,
    public val registrationDate: String? = null,
    public val registrationId: String? = null,
    public val serializedDetails: String? = null,
    public val state: String? = null,
    public val subscriptionId: String? = null,
    public val tenantId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.databoxedge.outputs.EdgeProfileSubscriptionResponse):
            EdgeProfileSubscriptionResponse = EdgeProfileSubscriptionResponse(
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            locationPlacementId = javaType.locationPlacementId().map({ args0 -> args0 }).orElse(null),
            quotaId = javaType.quotaId().map({ args0 -> args0 }).orElse(null),
            registeredFeatures = javaType.registeredFeatures().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databoxedge.kotlin.outputs.SubscriptionRegisteredFeaturesResponse.Companion.toKotlin(args0)
                })
            }),
            registrationDate = javaType.registrationDate().map({ args0 -> args0 }).orElse(null),
            registrationId = javaType.registrationId().map({ args0 -> args0 }).orElse(null),
            serializedDetails = javaType.serializedDetails().map({ args0 -> args0 }).orElse(null),
            state = javaType.state().map({ args0 -> args0 }).orElse(null),
            subscriptionId = javaType.subscriptionId().map({ args0 -> args0 }).orElse(null),
            tenantId = javaType.tenantId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
