@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Represents a container on the  Data Box Edge/Gateway device.
 * @property containerStatus Current status of the container.
 * @property createdDateTime The UTC time when container got created.
 * @property dataFormat DataFormat for Container
 * @property id The path ID that uniquely identifies the object.
 * @property name The object name.
 * @property refreshDetails Details of the refresh job on this container.
 * @property systemData Metadata pertaining to creation and last modification of Container
 * @property type The hierarchical type of the object.
 */
public data class GetContainerResult(
    public val containerStatus: String,
    public val createdDateTime: String,
    public val dataFormat: String,
    public val id: String,
    public val name: String,
    public val refreshDetails: RefreshDetailsResponse,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databoxedge.outputs.GetContainerResult):
            GetContainerResult = GetContainerResult(
            containerStatus = javaType.containerStatus(),
            createdDateTime = javaType.createdDateTime(),
            dataFormat = javaType.dataFormat(),
            id = javaType.id(),
            name = javaType.name(),
            refreshDetails = javaType.refreshDetails().let({ args0 ->
                com.pulumi.azurenative.databoxedge.kotlin.outputs.RefreshDetailsResponse.Companion.toKotlin(args0)
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.databoxedge.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
