@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The limited preview of Kubernetes Cluster Management from the Azure supports:
 * 1. Using a simple turn-key option in Azure Portal, deploy a Kubernetes cluster on your Azure Stack Edge device.
 * 2. Configure Kubernetes cluster running on your device with Arc enabled Kubernetes with a click of a button in the Azure Portal.
 *  Azure Arc enables organizations to view, manage, and govern their on-premises Kubernetes clusters using the Azure Portal, command line tools, and APIs.
 * 3. Easily configure Persistent Volumes using SMB and NFS shares for storing container data.
 *  For more information, refer to the document here: https://databoxupdatepackages.blob.core.windows.net/documentation/Microsoft-Azure-Stack-Edge-K8-Cloud-Management-20210323.pdf
 *  Or Demo: https://databoxupdatepackages.blob.core.windows.net/documentation/Microsoft-Azure-Stack-Edge-K8S-Cloud-Management-20210323.mp4
 *  By using this feature, you agree to the preview legal terms. See the https://azure.microsoft.com/en-us/support/legal/preview-supplemental-terms/
 * @property hostPlatform Host OS supported by the Kubernetes role.
 * @property hostPlatformType Platform where the runtime is hosted.
 * @property id The path ID that uniquely identifies the object.
 * @property kind Role type.
 * Expected value is 'Kubernetes'.
 * @property kubernetesClusterInfo Kubernetes cluster configuration
 * @property kubernetesRoleResources Kubernetes role resources
 * @property name The object name.
 * @property provisioningState State of Kubernetes deployment
 * @property roleStatus Role status.
 * @property systemData Metadata pertaining to creation and last modification of Role
 * @property type The hierarchical type of the object.
 */
public data class GetKubernetesRoleResult(
    public val hostPlatform: String,
    public val hostPlatformType: String,
    public val id: String,
    public val kind: String,
    public val kubernetesClusterInfo: KubernetesClusterInfoResponse,
    public val kubernetesRoleResources: KubernetesRoleResourcesResponse,
    public val name: String,
    public val provisioningState: String,
    public val roleStatus: String,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.databoxedge.outputs.GetKubernetesRoleResult):
            GetKubernetesRoleResult = GetKubernetesRoleResult(
            hostPlatform = javaType.hostPlatform(),
            hostPlatformType = javaType.hostPlatformType(),
            id = javaType.id(),
            kind = javaType.kind(),
            kubernetesClusterInfo = javaType.kubernetesClusterInfo().let({ args0 ->
                com.pulumi.azurenative.databoxedge.kotlin.outputs.KubernetesClusterInfoResponse.Companion.toKotlin(args0)
            }),
            kubernetesRoleResources = javaType.kubernetesRoleResources().let({ args0 ->
                com.pulumi.azurenative.databoxedge.kotlin.outputs.KubernetesRoleResourcesResponse.Companion.toKotlin(args0)
            }),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            roleStatus = javaType.roleStatus(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.databoxedge.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
