@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The order details.
 * @property contactInformation The contact details.
 * @property currentStatus Current status of the order.
 * @property deliveryTrackingInfo Tracking information for the package delivered to the customer whether it has an original or a replacement device.
 * @property id The path ID that uniquely identifies the object.
 * @property kind It specify the order api version.
 * @property name The object name.
 * @property orderHistory List of status changes in the order.
 * @property orderId It specify the order resource id.
 * @property returnTrackingInfo Tracking information for the package returned from the customer whether it has an original or a replacement device.
 * @property serialNumber Serial number of the device.
 * @property shipmentType ShipmentType of the order
 * @property shippingAddress The shipping address.
 * @property systemData Metadata pertaining to creation and last modification of Order
 * @property type The hierarchical type of the object.
 */
public data class GetOrderResult(
    public val contactInformation: ContactDetailsResponse,
    public val currentStatus: OrderStatusResponse,
    public val deliveryTrackingInfo: List<TrackingInfoResponse>,
    public val id: String,
    public val kind: String,
    public val name: String,
    public val orderHistory: List<OrderStatusResponse>,
    public val orderId: String,
    public val returnTrackingInfo: List<TrackingInfoResponse>,
    public val serialNumber: String,
    public val shipmentType: String? = null,
    public val shippingAddress: AddressResponse? = null,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databoxedge.outputs.GetOrderResult):
            GetOrderResult = GetOrderResult(
            contactInformation = javaType.contactInformation().let({ args0 ->
                com.pulumi.azurenative.databoxedge.kotlin.outputs.ContactDetailsResponse.Companion.toKotlin(args0)
            }),
            currentStatus = javaType.currentStatus().let({ args0 ->
                com.pulumi.azurenative.databoxedge.kotlin.outputs.OrderStatusResponse.Companion.toKotlin(args0)
            }),
            deliveryTrackingInfo = javaType.deliveryTrackingInfo().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databoxedge.kotlin.outputs.TrackingInfoResponse.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            kind = javaType.kind(),
            name = javaType.name(),
            orderHistory = javaType.orderHistory().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databoxedge.kotlin.outputs.OrderStatusResponse.Companion.toKotlin(args0)
                })
            }),
            orderId = javaType.orderId(),
            returnTrackingInfo = javaType.returnTrackingInfo().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databoxedge.kotlin.outputs.TrackingInfoResponse.Companion.toKotlin(args0)
                })
            }),
            serialNumber = javaType.serialNumber(),
            shipmentType = javaType.shipmentType().map({ args0 -> args0 }).orElse(null),
            shippingAddress = javaType.shippingAddress().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databoxedge.kotlin.outputs.AddressResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.databoxedge.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
