@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Trigger details.
 * @property customContextTag A custom context tag typically used to correlate the trigger against its usage. For example, if a periodic timer trigger is intended for certain specific IoT modules in the device, the tag can be the name or the image URL of the module.
 * @property id The path ID that uniquely identifies the object.
 * @property kind Trigger Kind.
 * Expected value is 'PeriodicTimerEvent'.
 * @property name The object name.
 * @property sinkInfo Role Sink information.
 * @property sourceInfo Periodic timer details.
 * @property systemData Metadata pertaining to creation and last modification of Trigger
 * @property type The hierarchical type of the object.
 */
public data class GetPeriodicTimerEventTriggerResult(
    public val customContextTag: String? = null,
    public val id: String,
    public val kind: String,
    public val name: String,
    public val sinkInfo: RoleSinkInfoResponse,
    public val sourceInfo: PeriodicTimerSourceInfoResponse,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.databoxedge.outputs.GetPeriodicTimerEventTriggerResult):
            GetPeriodicTimerEventTriggerResult = GetPeriodicTimerEventTriggerResult(
            customContextTag = javaType.customContextTag().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            kind = javaType.kind(),
            name = javaType.name(),
            sinkInfo = javaType.sinkInfo().let({ args0 ->
                com.pulumi.azurenative.databoxedge.kotlin.outputs.RoleSinkInfoResponse.Companion.toKotlin(args0)
            }),
            sourceInfo = javaType.sourceInfo().let({ args0 ->
                com.pulumi.azurenative.databoxedge.kotlin.outputs.PeriodicTimerSourceInfoResponse.Companion.toKotlin(args0)
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.databoxedge.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
