@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The metric dimension
 * @property sourceName The dimension value.
 * @property sourceType The dimension type.
 */
public data class MetricDimensionResponse(
    public val sourceName: String,
    public val sourceType: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.databoxedge.outputs.MetricDimensionResponse):
            MetricDimensionResponse = MetricDimensionResponse(
            sourceName = javaType.sourceName(),
            sourceType = javaType.sourceType(),
        )
    }
}
