@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databricks.kotlin

import com.pulumi.azurenative.databricks.DatabricksFunctions.getAccessConnectorPlain
import com.pulumi.azurenative.databricks.DatabricksFunctions.getPrivateEndpointConnectionPlain
import com.pulumi.azurenative.databricks.DatabricksFunctions.getVNetPeeringPlain
import com.pulumi.azurenative.databricks.DatabricksFunctions.getWorkspacePlain
import com.pulumi.azurenative.databricks.kotlin.inputs.GetAccessConnectorPlainArgs
import com.pulumi.azurenative.databricks.kotlin.inputs.GetAccessConnectorPlainArgsBuilder
import com.pulumi.azurenative.databricks.kotlin.inputs.GetPrivateEndpointConnectionPlainArgs
import com.pulumi.azurenative.databricks.kotlin.inputs.GetPrivateEndpointConnectionPlainArgsBuilder
import com.pulumi.azurenative.databricks.kotlin.inputs.GetVNetPeeringPlainArgs
import com.pulumi.azurenative.databricks.kotlin.inputs.GetVNetPeeringPlainArgsBuilder
import com.pulumi.azurenative.databricks.kotlin.inputs.GetWorkspacePlainArgs
import com.pulumi.azurenative.databricks.kotlin.inputs.GetWorkspacePlainArgsBuilder
import com.pulumi.azurenative.databricks.kotlin.outputs.GetAccessConnectorResult
import com.pulumi.azurenative.databricks.kotlin.outputs.GetPrivateEndpointConnectionResult
import com.pulumi.azurenative.databricks.kotlin.outputs.GetVNetPeeringResult
import com.pulumi.azurenative.databricks.kotlin.outputs.GetWorkspaceResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.databricks.kotlin.outputs.GetAccessConnectorResult.Companion.toKotlin as getAccessConnectorResultToKotlin
import com.pulumi.azurenative.databricks.kotlin.outputs.GetPrivateEndpointConnectionResult.Companion.toKotlin as getPrivateEndpointConnectionResultToKotlin
import com.pulumi.azurenative.databricks.kotlin.outputs.GetVNetPeeringResult.Companion.toKotlin as getVNetPeeringResultToKotlin
import com.pulumi.azurenative.databricks.kotlin.outputs.GetWorkspaceResult.Companion.toKotlin as getWorkspaceResultToKotlin

public object DatabricksFunctions {
    /**
     * Gets an azure databricks accessConnector.
     * Azure REST API version: 2023-05-01.
     * Other available API versions: 2022-04-01-preview.
     * @param argument null
     * @return Information about azure databricks accessConnector.
     */
    public suspend fun getAccessConnector(argument: GetAccessConnectorPlainArgs):
        GetAccessConnectorResult =
        getAccessConnectorResultToKotlin(getAccessConnectorPlain(argument.toJava()).await())

    /**
     * @see [getAccessConnector].
     * @param connectorName The name of the azure databricks accessConnector.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Information about azure databricks accessConnector.
     */
    public suspend fun getAccessConnector(connectorName: String, resourceGroupName: String):
        GetAccessConnectorResult {
        val argument = GetAccessConnectorPlainArgs(
            connectorName = connectorName,
            resourceGroupName = resourceGroupName,
        )
        return getAccessConnectorResultToKotlin(getAccessConnectorPlain(argument.toJava()).await())
    }

    /**
     * @see [getAccessConnector].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;databricks&#46;kotlin&#46;inputs&#46;GetAccessConnectorPlainArgs].
     * @return Information about azure databricks accessConnector.
     */
    public suspend
    fun getAccessConnector(argument: suspend GetAccessConnectorPlainArgsBuilder.() -> Unit):
        GetAccessConnectorResult {
        val builder = GetAccessConnectorPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAccessConnectorResultToKotlin(getAccessConnectorPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a private endpoint connection properties for a workspace
     * Azure REST API version: 2023-02-01.
     * @param argument null
     * @return The private endpoint connection of a workspace
     */
    public suspend fun getPrivateEndpointConnection(argument: GetPrivateEndpointConnectionPlainArgs):
        GetPrivateEndpointConnectionResult =
        getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(argument.toJava()).await())

    /**
     * @see [getPrivateEndpointConnection].
     * @param privateEndpointConnectionName The name of the private endpoint connection
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The name of the workspace.
     * @return The private endpoint connection of a workspace
     */
    public suspend fun getPrivateEndpointConnection(
        privateEndpointConnectionName: String,
        resourceGroupName: String,
        workspaceName: String,
    ): GetPrivateEndpointConnectionResult {
        val argument = GetPrivateEndpointConnectionPlainArgs(
            privateEndpointConnectionName = privateEndpointConnectionName,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getPrivateEndpointConnection].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;databricks&#46;kotlin&#46;inputs&#46;GetPrivateEndpointConnectionPlainArgs].
     * @return The private endpoint connection of a workspace
     */
    public suspend
    fun getPrivateEndpointConnection(argument: suspend GetPrivateEndpointConnectionPlainArgsBuilder.() -> Unit):
        GetPrivateEndpointConnectionResult {
        val builder = GetPrivateEndpointConnectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the workspace vNet Peering.
     * Azure REST API version: 2023-02-01.
     * @param argument null
     * @return Peerings in a VirtualNetwork resource
     */
    public suspend fun getVNetPeering(argument: GetVNetPeeringPlainArgs): GetVNetPeeringResult =
        getVNetPeeringResultToKotlin(getVNetPeeringPlain(argument.toJava()).await())

    /**
     * @see [getVNetPeering].
     * @param peeringName The name of the workspace vNet peering.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The name of the workspace.
     * @return Peerings in a VirtualNetwork resource
     */
    public suspend fun getVNetPeering(
        peeringName: String,
        resourceGroupName: String,
        workspaceName: String,
    ): GetVNetPeeringResult {
        val argument = GetVNetPeeringPlainArgs(
            peeringName = peeringName,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getVNetPeeringResultToKotlin(getVNetPeeringPlain(argument.toJava()).await())
    }

    /**
     * @see [getVNetPeering].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;databricks&#46;kotlin&#46;inputs&#46;GetVNetPeeringPlainArgs].
     * @return Peerings in a VirtualNetwork resource
     */
    public suspend fun getVNetPeering(argument: suspend GetVNetPeeringPlainArgsBuilder.() -> Unit):
        GetVNetPeeringResult {
        val builder = GetVNetPeeringPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVNetPeeringResultToKotlin(getVNetPeeringPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the workspace.
     * Azure REST API version: 2023-02-01.
     * @param argument null
     * @return Information about workspace.
     */
    public suspend fun getWorkspace(argument: GetWorkspacePlainArgs): GetWorkspaceResult =
        getWorkspaceResultToKotlin(getWorkspacePlain(argument.toJava()).await())

    /**
     * @see [getWorkspace].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The name of the workspace.
     * @return Information about workspace.
     */
    public suspend fun getWorkspace(resourceGroupName: String, workspaceName: String):
        GetWorkspaceResult {
        val argument = GetWorkspacePlainArgs(
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getWorkspaceResultToKotlin(getWorkspacePlain(argument.toJava()).await())
    }

    /**
     * @see [getWorkspace].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;databricks&#46;kotlin&#46;inputs&#46;GetWorkspacePlainArgs].
     * @return Information about workspace.
     */
    public suspend fun getWorkspace(argument: suspend GetWorkspacePlainArgsBuilder.() -> Unit):
        GetWorkspaceResult {
        val builder = GetWorkspacePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getWorkspaceResultToKotlin(getWorkspacePlain(builtArgument.toJava()).await())
    }
}
