@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databricks.kotlin.inputs

import com.pulumi.azurenative.databricks.inputs.EncryptionArgs.builder
import com.pulumi.azurenative.databricks.kotlin.enums.KeySource
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The object that contains details of encryption used on the workspace.
 * @property keyName The name of KeyVault key.
 * @property keySource The encryption keySource (provider). Possible values (case-insensitive):  Default, Microsoft.Keyvault
 * @property keyVaultUri The Uri of KeyVault.
 * @property keyVersion The version of KeyVault key.
 */
public data class EncryptionArgs(
    public val keyName: Output<String>? = null,
    public val keySource: Output<Either<String, KeySource>>? = null,
    public val keyVaultUri: Output<String>? = null,
    public val keyVersion: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.databricks.inputs.EncryptionArgs> {
    override fun toJava(): com.pulumi.azurenative.databricks.inputs.EncryptionArgs =
        com.pulumi.azurenative.databricks.inputs.EncryptionArgs.builder()
            .keyName(keyName?.applyValue({ args0 -> args0 }))
            .keySource(
                keySource?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .keyVaultUri(keyVaultUri?.applyValue({ args0 -> args0 }))
            .keyVersion(keyVersion?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EncryptionArgs].
 */
@PulumiTagMarker
public class EncryptionArgsBuilder internal constructor() {
    private var keyName: Output<String>? = null

    private var keySource: Output<Either<String, KeySource>>? = null

    private var keyVaultUri: Output<String>? = null

    private var keyVersion: Output<String>? = null

    /**
     * @param value The name of KeyVault key.
     */
    @JvmName("msqcimxxviufkrfj")
    public suspend fun keyName(`value`: Output<String>) {
        this.keyName = value
    }

    /**
     * @param value The encryption keySource (provider). Possible values (case-insensitive):  Default, Microsoft.Keyvault
     */
    @JvmName("tdkdaeajfohnrcme")
    public suspend fun keySource(`value`: Output<Either<String, KeySource>>) {
        this.keySource = value
    }

    /**
     * @param value The Uri of KeyVault.
     */
    @JvmName("pbspnfacfidronuv")
    public suspend fun keyVaultUri(`value`: Output<String>) {
        this.keyVaultUri = value
    }

    /**
     * @param value The version of KeyVault key.
     */
    @JvmName("mwyroamveqrtahjc")
    public suspend fun keyVersion(`value`: Output<String>) {
        this.keyVersion = value
    }

    /**
     * @param value The name of KeyVault key.
     */
    @JvmName("udgylpnwjglsdfoy")
    public suspend fun keyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyName = mapped
    }

    /**
     * @param value The encryption keySource (provider). Possible values (case-insensitive):  Default, Microsoft.Keyvault
     */
    @JvmName("gpsotksmqvjghjrs")
    public suspend fun keySource(`value`: Either<String, KeySource>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keySource = mapped
    }

    /**
     * @param value The encryption keySource (provider). Possible values (case-insensitive):  Default, Microsoft.Keyvault
     */
    @JvmName("qikevvmgladiidvg")
    public fun keySource(`value`: String) {
        val toBeMapped = Either.ofLeft<String, KeySource>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keySource = mapped
    }

    /**
     * @param value The encryption keySource (provider). Possible values (case-insensitive):  Default, Microsoft.Keyvault
     */
    @JvmName("qkjbqsodwstouajo")
    public fun keySource(`value`: KeySource) {
        val toBeMapped = Either.ofRight<String, KeySource>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keySource = mapped
    }

    /**
     * @param value The Uri of KeyVault.
     */
    @JvmName("xrfrmyaehnaaukjg")
    public suspend fun keyVaultUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVaultUri = mapped
    }

    /**
     * @param value The version of KeyVault key.
     */
    @JvmName("xqfxlpsutbvsjvlh")
    public suspend fun keyVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVersion = mapped
    }

    internal fun build(): EncryptionArgs = EncryptionArgs(
        keyName = keyName,
        keySource = keySource,
        keyVaultUri = keyVaultUri,
        keyVersion = keyVersion,
    )
}
