@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databricks.kotlin.inputs

import com.pulumi.azurenative.databricks.inputs.EncryptionV2KeyVaultPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Key Vault input properties for encryption.
 * @property keyName The name of KeyVault key.
 * @property keyVaultUri The Uri of KeyVault.
 * @property keyVersion The version of KeyVault key.
 */
public data class EncryptionV2KeyVaultPropertiesArgs(
    public val keyName: Output<String>,
    public val keyVaultUri: Output<String>,
    public val keyVersion: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.databricks.inputs.EncryptionV2KeyVaultPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.databricks.inputs.EncryptionV2KeyVaultPropertiesArgs =
        com.pulumi.azurenative.databricks.inputs.EncryptionV2KeyVaultPropertiesArgs.builder()
            .keyName(keyName.applyValue({ args0 -> args0 }))
            .keyVaultUri(keyVaultUri.applyValue({ args0 -> args0 }))
            .keyVersion(keyVersion.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EncryptionV2KeyVaultPropertiesArgs].
 */
@PulumiTagMarker
public class EncryptionV2KeyVaultPropertiesArgsBuilder internal constructor() {
    private var keyName: Output<String>? = null

    private var keyVaultUri: Output<String>? = null

    private var keyVersion: Output<String>? = null

    /**
     * @param value The name of KeyVault key.
     */
    @JvmName("yiggaqpghscutppp")
    public suspend fun keyName(`value`: Output<String>) {
        this.keyName = value
    }

    /**
     * @param value The Uri of KeyVault.
     */
    @JvmName("aejtscculfothmhv")
    public suspend fun keyVaultUri(`value`: Output<String>) {
        this.keyVaultUri = value
    }

    /**
     * @param value The version of KeyVault key.
     */
    @JvmName("dklgobepdelbmieh")
    public suspend fun keyVersion(`value`: Output<String>) {
        this.keyVersion = value
    }

    /**
     * @param value The name of KeyVault key.
     */
    @JvmName("mjysyjlqmptiqaxc")
    public suspend fun keyName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keyName = mapped
    }

    /**
     * @param value The Uri of KeyVault.
     */
    @JvmName("hrqcyjwsgfssmeqn")
    public suspend fun keyVaultUri(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keyVaultUri = mapped
    }

    /**
     * @param value The version of KeyVault key.
     */
    @JvmName("mxqjudumvfmxqmup")
    public suspend fun keyVersion(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keyVersion = mapped
    }

    internal fun build(): EncryptionV2KeyVaultPropertiesArgs = EncryptionV2KeyVaultPropertiesArgs(
        keyName = keyName ?: throw PulumiNullFieldException("keyName"),
        keyVaultUri = keyVaultUri ?: throw PulumiNullFieldException("keyVaultUri"),
        keyVersion = keyVersion ?: throw PulumiNullFieldException("keyVersion"),
    )
}
