@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databricks.kotlin.inputs

import com.pulumi.azurenative.databricks.inputs.ManagedDiskEncryptionArgs.builder
import com.pulumi.azurenative.databricks.kotlin.enums.EncryptionKeySource
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The object that contains details of encryption used on the workspace.
 * @property keySource The encryption keySource (provider). Possible values (case-insensitive):  Microsoft.Keyvault
 * @property keyVaultProperties Key Vault input properties for encryption.
 * @property rotationToLatestKeyVersionEnabled Indicate whether the latest key version should be automatically used for Managed Disk Encryption.
 */
public data class ManagedDiskEncryptionArgs(
    public val keySource: Output<Either<String, EncryptionKeySource>>,
    public val keyVaultProperties: Output<ManagedDiskEncryptionKeyVaultPropertiesArgs>,
    public val rotationToLatestKeyVersionEnabled: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.databricks.inputs.ManagedDiskEncryptionArgs> {
    override fun toJava(): com.pulumi.azurenative.databricks.inputs.ManagedDiskEncryptionArgs =
        com.pulumi.azurenative.databricks.inputs.ManagedDiskEncryptionArgs.builder()
            .keySource(
                keySource.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .keyVaultProperties(
                keyVaultProperties.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .rotationToLatestKeyVersionEnabled(
                rotationToLatestKeyVersionEnabled?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [ManagedDiskEncryptionArgs].
 */
@PulumiTagMarker
public class ManagedDiskEncryptionArgsBuilder internal constructor() {
    private var keySource: Output<Either<String, EncryptionKeySource>>? = null

    private var keyVaultProperties: Output<ManagedDiskEncryptionKeyVaultPropertiesArgs>? = null

    private var rotationToLatestKeyVersionEnabled: Output<Boolean>? = null

    /**
     * @param value The encryption keySource (provider). Possible values (case-insensitive):  Microsoft.Keyvault
     */
    @JvmName("bhqxuswgusjxbyvr")
    public suspend fun keySource(`value`: Output<Either<String, EncryptionKeySource>>) {
        this.keySource = value
    }

    /**
     * @param value Key Vault input properties for encryption.
     */
    @JvmName("smygdqcmdmvhyheb")
    public suspend
    fun keyVaultProperties(`value`: Output<ManagedDiskEncryptionKeyVaultPropertiesArgs>) {
        this.keyVaultProperties = value
    }

    /**
     * @param value Indicate whether the latest key version should be automatically used for Managed Disk Encryption.
     */
    @JvmName("owaxofoqxkgvuesp")
    public suspend fun rotationToLatestKeyVersionEnabled(`value`: Output<Boolean>) {
        this.rotationToLatestKeyVersionEnabled = value
    }

    /**
     * @param value The encryption keySource (provider). Possible values (case-insensitive):  Microsoft.Keyvault
     */
    @JvmName("dblpqsrkjoworcny")
    public suspend fun keySource(`value`: Either<String, EncryptionKeySource>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keySource = mapped
    }

    /**
     * @param value The encryption keySource (provider). Possible values (case-insensitive):  Microsoft.Keyvault
     */
    @JvmName("exxpglsbauquoaku")
    public fun keySource(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EncryptionKeySource>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keySource = mapped
    }

    /**
     * @param value The encryption keySource (provider). Possible values (case-insensitive):  Microsoft.Keyvault
     */
    @JvmName("yitkhgmteoykvsww")
    public fun keySource(`value`: EncryptionKeySource) {
        val toBeMapped = Either.ofRight<String, EncryptionKeySource>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keySource = mapped
    }

    /**
     * @param value Key Vault input properties for encryption.
     */
    @JvmName("btlvcabyydbjhxgg")
    public suspend fun keyVaultProperties(`value`: ManagedDiskEncryptionKeyVaultPropertiesArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keyVaultProperties = mapped
    }

    /**
     * @param argument Key Vault input properties for encryption.
     */
    @JvmName("xoliktuxximkxknh")
    public suspend
    fun keyVaultProperties(argument: suspend ManagedDiskEncryptionKeyVaultPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedDiskEncryptionKeyVaultPropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.keyVaultProperties = mapped
    }

    /**
     * @param value Indicate whether the latest key version should be automatically used for Managed Disk Encryption.
     */
    @JvmName("wmryxjvkskjfxthx")
    public suspend fun rotationToLatestKeyVersionEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rotationToLatestKeyVersionEnabled = mapped
    }

    internal fun build(): ManagedDiskEncryptionArgs = ManagedDiskEncryptionArgs(
        keySource = keySource ?: throw PulumiNullFieldException("keySource"),
        keyVaultProperties = keyVaultProperties ?: throw PulumiNullFieldException("keyVaultProperties"),
        rotationToLatestKeyVersionEnabled = rotationToLatestKeyVersionEnabled,
    )
}
