@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databricks.kotlin.inputs

import com.pulumi.azurenative.databricks.inputs.WorkspaceEncryptionParameterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The object that contains details of encryption used on the workspace.
 * @property value The value which should be used for this field.
 */
public data class WorkspaceEncryptionParameterArgs(
    public val `value`: Output<EncryptionArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.databricks.inputs.WorkspaceEncryptionParameterArgs> {
    override fun toJava(): com.pulumi.azurenative.databricks.inputs.WorkspaceEncryptionParameterArgs =
        com.pulumi.azurenative.databricks.inputs.WorkspaceEncryptionParameterArgs.builder()
            .`value`(`value`?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [WorkspaceEncryptionParameterArgs].
 */
@PulumiTagMarker
public class WorkspaceEncryptionParameterArgsBuilder internal constructor() {
    private var `value`: Output<EncryptionArgs>? = null

    /**
     * @param value The value which should be used for this field.
     */
    @JvmName("dobgkonkketqmbbs")
    public suspend fun `value`(`value`: Output<EncryptionArgs>) {
        this.`value` = value
    }

    /**
     * @param value The value which should be used for this field.
     */
    @JvmName("qnswouvwvadsuwbw")
    public suspend fun `value`(`value`: EncryptionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    /**
     * @param argument The value which should be used for this field.
     */
    @JvmName("qoqnpjngxjktbdeo")
    public suspend fun `value`(argument: suspend EncryptionArgsBuilder.() -> Unit) {
        val toBeMapped = EncryptionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.`value` = mapped
    }

    internal fun build(): WorkspaceEncryptionParameterArgs = WorkspaceEncryptionParameterArgs(
        `value` = `value`,
    )
}
