@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databricks.kotlin.inputs

import com.pulumi.azurenative.databricks.inputs.WorkspacePropertiesEncryptionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Encryption properties for databricks workspace
 * @property entities Encryption entities definition for the workspace.
 */
public data class WorkspacePropertiesEncryptionArgs(
    public val entities: Output<EncryptionEntitiesDefinitionArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.databricks.inputs.WorkspacePropertiesEncryptionArgs> {
    override fun toJava(): com.pulumi.azurenative.databricks.inputs.WorkspacePropertiesEncryptionArgs =
        com.pulumi.azurenative.databricks.inputs.WorkspacePropertiesEncryptionArgs.builder()
            .entities(entities.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [WorkspacePropertiesEncryptionArgs].
 */
@PulumiTagMarker
public class WorkspacePropertiesEncryptionArgsBuilder internal constructor() {
    private var entities: Output<EncryptionEntitiesDefinitionArgs>? = null

    /**
     * @param value Encryption entities definition for the workspace.
     */
    @JvmName("bmrvdamocmdxeoks")
    public suspend fun entities(`value`: Output<EncryptionEntitiesDefinitionArgs>) {
        this.entities = value
    }

    /**
     * @param value Encryption entities definition for the workspace.
     */
    @JvmName("oxxdmdjcrsbjpqwr")
    public suspend fun entities(`value`: EncryptionEntitiesDefinitionArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.entities = mapped
    }

    /**
     * @param argument Encryption entities definition for the workspace.
     */
    @JvmName("hvumjgccdujwfqoq")
    public suspend
    fun entities(argument: suspend EncryptionEntitiesDefinitionArgsBuilder.() -> Unit) {
        val toBeMapped = EncryptionEntitiesDefinitionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.entities = mapped
    }

    internal fun build(): WorkspacePropertiesEncryptionArgs = WorkspacePropertiesEncryptionArgs(
        entities = entities ?: throw PulumiNullFieldException("entities"),
    )
}
