@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datacatalog.kotlin.inputs

import com.pulumi.azurenative.datacatalog.inputs.PrincipalsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * User principals.
 * @property objectId Object Id for the user
 * @property upn UPN of the user.
 */
public data class PrincipalsArgs(
    public val objectId: Output<String>? = null,
    public val upn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datacatalog.inputs.PrincipalsArgs> {
    override fun toJava(): com.pulumi.azurenative.datacatalog.inputs.PrincipalsArgs =
        com.pulumi.azurenative.datacatalog.inputs.PrincipalsArgs.builder()
            .objectId(objectId?.applyValue({ args0 -> args0 }))
            .upn(upn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PrincipalsArgs].
 */
@PulumiTagMarker
public class PrincipalsArgsBuilder internal constructor() {
    private var objectId: Output<String>? = null

    private var upn: Output<String>? = null

    /**
     * @param value Object Id for the user
     */
    @JvmName("maymvtvwumttivav")
    public suspend fun objectId(`value`: Output<String>) {
        this.objectId = value
    }

    /**
     * @param value UPN of the user.
     */
    @JvmName("asfxvjysowljbmgu")
    public suspend fun upn(`value`: Output<String>) {
        this.upn = value
    }

    /**
     * @param value Object Id for the user
     */
    @JvmName("pkuvnemvvjpofuxj")
    public suspend fun objectId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.objectId = mapped
    }

    /**
     * @param value UPN of the user.
     */
    @JvmName("ecmspksloafhufcg")
    public suspend fun upn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.upn = mapped
    }

    internal fun build(): PrincipalsArgs = PrincipalsArgs(
        objectId = objectId,
        upn = upn,
    )
}
