@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datadog.kotlin

import com.pulumi.azurenative.datadog.kotlin.outputs.IdentityPropertiesResponse
import com.pulumi.azurenative.datadog.kotlin.outputs.MonitorPropertiesResponse
import com.pulumi.azurenative.datadog.kotlin.outputs.ResourceSkuResponse
import com.pulumi.azurenative.datadog.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.datadog.kotlin.outputs.IdentityPropertiesResponse.Companion.toKotlin as identityPropertiesResponseToKotlin
import com.pulumi.azurenative.datadog.kotlin.outputs.MonitorPropertiesResponse.Companion.toKotlin as monitorPropertiesResponseToKotlin
import com.pulumi.azurenative.datadog.kotlin.outputs.ResourceSkuResponse.Companion.toKotlin as resourceSkuResponseToKotlin
import com.pulumi.azurenative.datadog.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Monitor].
 */
@PulumiTagMarker
public class MonitorResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MonitorArgs = MonitorArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MonitorArgsBuilder.() -> Unit) {
        val builder = MonitorArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Monitor {
        val builtJavaResource = com.pulumi.azurenative.datadog.Monitor(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Monitor(builtJavaResource)
    }
}

/**
 *
 * Azure REST API version: 2022-06-01. Prior API version in Azure Native 1.x: 2021-03-01.
 * Other available API versions: 2022-08-01, 2023-01-01.
 * ## Example Usage
 * ### Monitors_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var monitor = new AzureNative.Datadog.Monitor("monitor", new()
 *     {
 *         MonitorName = "myMonitor",
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datadog/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datadog.NewMonitor(ctx, "monitor", &datadog.MonitorArgs{
 * 			MonitorName:       pulumi.String("myMonitor"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datadog.Monitor;
 * import com.pulumi.azurenative.datadog.MonitorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var monitor = new Monitor("monitor", MonitorArgs.builder()
 *             .monitorName("myMonitor")
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:datadog:Monitor myMonitor /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Datadog/monitors/{monitorName}
 * ```
 */
public class Monitor internal constructor(
    override val javaResource: com.pulumi.azurenative.datadog.Monitor,
) : KotlinCustomResource(javaResource, MonitorMapper) {
    public val identity: Output<IdentityPropertiesResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    identityPropertiesResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Name of the monitor resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Properties specific to the monitor resource.
     */
    public val properties: Output<MonitorPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                monitorPropertiesResponseToKotlin(args0)
            })
        })

    public val sku: Output<ResourceSkuResponse>?
        get() = javaResource.sku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    resourceSkuResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the monitor resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object MonitorMapper : ResourceMapper<Monitor> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.datadog.Monitor::class == javaResource::class

    override fun map(javaResource: Resource): Monitor = Monitor(
        javaResource as
            com.pulumi.azurenative.datadog.Monitor,
    )
}

/**
 * @see [Monitor].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Monitor].
 */
public suspend fun monitor(name: String, block: suspend MonitorResourceBuilder.() -> Unit):
    Monitor {
    val builder = MonitorResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Monitor].
 * @param name The _unique_ name of the resulting resource.
 */
public fun monitor(name: String): Monitor {
    val builder = MonitorResourceBuilder()
    builder.name(name)
    return builder.build()
}
