@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datadog.kotlin.inputs

import com.pulumi.azurenative.datadog.inputs.LogRulesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Set of rules for sending logs for the Monitor resource.
 * @property filteringTags List of filtering tags to be used for capturing logs. This only takes effect if SendResourceLogs flag is enabled. If empty, all resources will be captured. If only Exclude action is specified, the rules will apply to the list of all available resources. If Include actions are specified, the rules will only include resources with the associated tags.
 * @property sendAadLogs Flag specifying if AAD logs should be sent for the Monitor resource.
 * @property sendResourceLogs Flag specifying if Azure resource logs should be sent for the Monitor resource.
 * @property sendSubscriptionLogs Flag specifying if Azure subscription logs should be sent for the Monitor resource.
 */
public data class LogRulesArgs(
    public val filteringTags: Output<List<FilteringTagArgs>>? = null,
    public val sendAadLogs: Output<Boolean>? = null,
    public val sendResourceLogs: Output<Boolean>? = null,
    public val sendSubscriptionLogs: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datadog.inputs.LogRulesArgs> {
    override fun toJava(): com.pulumi.azurenative.datadog.inputs.LogRulesArgs =
        com.pulumi.azurenative.datadog.inputs.LogRulesArgs.builder()
            .filteringTags(
                filteringTags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .sendAadLogs(sendAadLogs?.applyValue({ args0 -> args0 }))
            .sendResourceLogs(sendResourceLogs?.applyValue({ args0 -> args0 }))
            .sendSubscriptionLogs(sendSubscriptionLogs?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LogRulesArgs].
 */
@PulumiTagMarker
public class LogRulesArgsBuilder internal constructor() {
    private var filteringTags: Output<List<FilteringTagArgs>>? = null

    private var sendAadLogs: Output<Boolean>? = null

    private var sendResourceLogs: Output<Boolean>? = null

    private var sendSubscriptionLogs: Output<Boolean>? = null

    /**
     * @param value List of filtering tags to be used for capturing logs. This only takes effect if SendResourceLogs flag is enabled. If empty, all resources will be captured. If only Exclude action is specified, the rules will apply to the list of all available resources. If Include actions are specified, the rules will only include resources with the associated tags.
     */
    @JvmName("qxayjbqysqqvantn")
    public suspend fun filteringTags(`value`: Output<List<FilteringTagArgs>>) {
        this.filteringTags = value
    }

    @JvmName("xcnwvkthvsddtyrl")
    public suspend fun filteringTags(vararg values: Output<FilteringTagArgs>) {
        this.filteringTags = Output.all(values.asList())
    }

    /**
     * @param values List of filtering tags to be used for capturing logs. This only takes effect if SendResourceLogs flag is enabled. If empty, all resources will be captured. If only Exclude action is specified, the rules will apply to the list of all available resources. If Include actions are specified, the rules will only include resources with the associated tags.
     */
    @JvmName("xbalqntnstuixulx")
    public suspend fun filteringTags(values: List<Output<FilteringTagArgs>>) {
        this.filteringTags = Output.all(values)
    }

    /**
     * @param value Flag specifying if AAD logs should be sent for the Monitor resource.
     */
    @JvmName("ajawfqorsxwtsllj")
    public suspend fun sendAadLogs(`value`: Output<Boolean>) {
        this.sendAadLogs = value
    }

    /**
     * @param value Flag specifying if Azure resource logs should be sent for the Monitor resource.
     */
    @JvmName("pojntrscnggaraoq")
    public suspend fun sendResourceLogs(`value`: Output<Boolean>) {
        this.sendResourceLogs = value
    }

    /**
     * @param value Flag specifying if Azure subscription logs should be sent for the Monitor resource.
     */
    @JvmName("txttwicluokpgtwv")
    public suspend fun sendSubscriptionLogs(`value`: Output<Boolean>) {
        this.sendSubscriptionLogs = value
    }

    /**
     * @param value List of filtering tags to be used for capturing logs. This only takes effect if SendResourceLogs flag is enabled. If empty, all resources will be captured. If only Exclude action is specified, the rules will apply to the list of all available resources. If Include actions are specified, the rules will only include resources with the associated tags.
     */
    @JvmName("rfosvpvifgcfpccu")
    public suspend fun filteringTags(`value`: List<FilteringTagArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filteringTags = mapped
    }

    /**
     * @param argument List of filtering tags to be used for capturing logs. This only takes effect if SendResourceLogs flag is enabled. If empty, all resources will be captured. If only Exclude action is specified, the rules will apply to the list of all available resources. If Include actions are specified, the rules will only include resources with the associated tags.
     */
    @JvmName("trqcptokwsxfxwcv")
    public suspend fun filteringTags(argument: List<suspend FilteringTagArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FilteringTagArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.filteringTags = mapped
    }

    /**
     * @param argument List of filtering tags to be used for capturing logs. This only takes effect if SendResourceLogs flag is enabled. If empty, all resources will be captured. If only Exclude action is specified, the rules will apply to the list of all available resources. If Include actions are specified, the rules will only include resources with the associated tags.
     */
    @JvmName("dhglubjxcoisomaa")
    public suspend fun filteringTags(vararg argument: suspend FilteringTagArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            FilteringTagArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.filteringTags = mapped
    }

    /**
     * @param argument List of filtering tags to be used for capturing logs. This only takes effect if SendResourceLogs flag is enabled. If empty, all resources will be captured. If only Exclude action is specified, the rules will apply to the list of all available resources. If Include actions are specified, the rules will only include resources with the associated tags.
     */
    @JvmName("xbwojgttxecnupix")
    public suspend fun filteringTags(argument: suspend FilteringTagArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(FilteringTagArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.filteringTags = mapped
    }

    /**
     * @param values List of filtering tags to be used for capturing logs. This only takes effect if SendResourceLogs flag is enabled. If empty, all resources will be captured. If only Exclude action is specified, the rules will apply to the list of all available resources. If Include actions are specified, the rules will only include resources with the associated tags.
     */
    @JvmName("nbdjrgflbqjwewap")
    public suspend fun filteringTags(vararg values: FilteringTagArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.filteringTags = mapped
    }

    /**
     * @param value Flag specifying if AAD logs should be sent for the Monitor resource.
     */
    @JvmName("icupbpbynugwrkrc")
    public suspend fun sendAadLogs(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sendAadLogs = mapped
    }

    /**
     * @param value Flag specifying if Azure resource logs should be sent for the Monitor resource.
     */
    @JvmName("ylfyosgwakgscjqy")
    public suspend fun sendResourceLogs(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sendResourceLogs = mapped
    }

    /**
     * @param value Flag specifying if Azure subscription logs should be sent for the Monitor resource.
     */
    @JvmName("xrsuacmrufrbtosi")
    public suspend fun sendSubscriptionLogs(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sendSubscriptionLogs = mapped
    }

    internal fun build(): LogRulesArgs = LogRulesArgs(
        filteringTags = filteringTags,
        sendAadLogs = sendAadLogs,
        sendResourceLogs = sendResourceLogs,
        sendSubscriptionLogs = sendSubscriptionLogs,
    )
}
