@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datadog.kotlin.inputs

import com.pulumi.azurenative.datadog.inputs.MonitoringTagRulesPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Definition of the properties for a TagRules resource.
 * @property automuting Configuration to enable/disable auto-muting flag
 * @property logRules Set of rules for sending logs for the Monitor resource.
 * @property metricRules Set of rules for sending metrics for the Monitor resource.
 */
public data class MonitoringTagRulesPropertiesArgs(
    public val automuting: Output<Boolean>? = null,
    public val logRules: Output<LogRulesArgs>? = null,
    public val metricRules: Output<MetricRulesArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datadog.inputs.MonitoringTagRulesPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.datadog.inputs.MonitoringTagRulesPropertiesArgs =
        com.pulumi.azurenative.datadog.inputs.MonitoringTagRulesPropertiesArgs.builder()
            .automuting(automuting?.applyValue({ args0 -> args0 }))
            .logRules(logRules?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .metricRules(metricRules?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [MonitoringTagRulesPropertiesArgs].
 */
@PulumiTagMarker
public class MonitoringTagRulesPropertiesArgsBuilder internal constructor() {
    private var automuting: Output<Boolean>? = null

    private var logRules: Output<LogRulesArgs>? = null

    private var metricRules: Output<MetricRulesArgs>? = null

    /**
     * @param value Configuration to enable/disable auto-muting flag
     */
    @JvmName("ebghutuvuboqgqqt")
    public suspend fun automuting(`value`: Output<Boolean>) {
        this.automuting = value
    }

    /**
     * @param value Set of rules for sending logs for the Monitor resource.
     */
    @JvmName("crrraddwcusytlfa")
    public suspend fun logRules(`value`: Output<LogRulesArgs>) {
        this.logRules = value
    }

    /**
     * @param value Set of rules for sending metrics for the Monitor resource.
     */
    @JvmName("bvyqqedvwfyrdiuq")
    public suspend fun metricRules(`value`: Output<MetricRulesArgs>) {
        this.metricRules = value
    }

    /**
     * @param value Configuration to enable/disable auto-muting flag
     */
    @JvmName("gvwlmqdfievdwuik")
    public suspend fun automuting(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.automuting = mapped
    }

    /**
     * @param value Set of rules for sending logs for the Monitor resource.
     */
    @JvmName("hgayimldpqxpdspq")
    public suspend fun logRules(`value`: LogRulesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logRules = mapped
    }

    /**
     * @param argument Set of rules for sending logs for the Monitor resource.
     */
    @JvmName("bmkosbvkydggmkdb")
    public suspend fun logRules(argument: suspend LogRulesArgsBuilder.() -> Unit) {
        val toBeMapped = LogRulesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.logRules = mapped
    }

    /**
     * @param value Set of rules for sending metrics for the Monitor resource.
     */
    @JvmName("gktghhjgfmygiupt")
    public suspend fun metricRules(`value`: MetricRulesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metricRules = mapped
    }

    /**
     * @param argument Set of rules for sending metrics for the Monitor resource.
     */
    @JvmName("kmfrwicguyxmcawt")
    public suspend fun metricRules(argument: suspend MetricRulesArgsBuilder.() -> Unit) {
        val toBeMapped = MetricRulesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.metricRules = mapped
    }

    internal fun build(): MonitoringTagRulesPropertiesArgs = MonitoringTagRulesPropertiesArgs(
        automuting = automuting,
        logRules = logRules,
        metricRules = metricRules,
    )
}
