@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datadog.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property installerVersion The installer version.
 * @property tool The tool.
 * @property toolVersion The tool version.
 */
public data class DatadogInstallMethodResponse(
    public val installerVersion: String? = null,
    public val tool: String? = null,
    public val toolVersion: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datadog.outputs.DatadogInstallMethodResponse):
            DatadogInstallMethodResponse = DatadogInstallMethodResponse(
            installerVersion = javaType.installerVersion().map({ args0 -> args0 }).orElse(null),
            tool = javaType.tool().map({ args0 -> args0 }).orElse(null),
            toolVersion = javaType.toolVersion().map({ args0 -> args0 }).orElse(null),
        )
    }
}
