@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datadog.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress
import kotlin.collections.List

/**
 * Set of rules for sending logs for the Monitor resource.
 * @property filteringTags List of filtering tags to be used for capturing logs. This only takes effect if SendResourceLogs flag is enabled. If empty, all resources will be captured. If only Exclude action is specified, the rules will apply to the list of all available resources. If Include actions are specified, the rules will only include resources with the associated tags.
 * @property sendAadLogs Flag specifying if AAD logs should be sent for the Monitor resource.
 * @property sendResourceLogs Flag specifying if Azure resource logs should be sent for the Monitor resource.
 * @property sendSubscriptionLogs Flag specifying if Azure subscription logs should be sent for the Monitor resource.
 */
public data class LogRulesResponse(
    public val filteringTags: List<FilteringTagResponse>? = null,
    public val sendAadLogs: Boolean? = null,
    public val sendResourceLogs: Boolean? = null,
    public val sendSubscriptionLogs: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datadog.outputs.LogRulesResponse):
            LogRulesResponse = LogRulesResponse(
            filteringTags = javaType.filteringTags().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datadog.kotlin.outputs.FilteringTagResponse.Companion.toKotlin(args0)
                })
            }),
            sendAadLogs = javaType.sendAadLogs().map({ args0 -> args0 }).orElse(null),
            sendResourceLogs = javaType.sendResourceLogs().map({ args0 -> args0 }).orElse(null),
            sendSubscriptionLogs = javaType.sendSubscriptionLogs().map({ args0 -> args0 }).orElse(null),
        )
    }
}
