@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin

import com.pulumi.azurenative.datafactory.kotlin.outputs.GlobalParameterSpecificationResponse
import com.pulumi.azurenative.datafactory.kotlin.outputs.GlobalParameterSpecificationResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [GlobalParameter].
 */
@PulumiTagMarker
public class GlobalParameterResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GlobalParameterArgs = GlobalParameterArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GlobalParameterArgsBuilder.() -> Unit) {
        val builder = GlobalParameterArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): GlobalParameter {
        val builtJavaResource =
            com.pulumi.azurenative.datafactory.GlobalParameter(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return GlobalParameter(builtJavaResource)
    }
}

/**
 * Global parameters resource type.
 * Azure REST API version: 2018-06-01. Prior API version in Azure Native 1.x: 2018-06-01.
 * ## Example Usage
 * ### GlobalParameters_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var globalParameter = new AzureNative.DataFactory.GlobalParameter("globalParameter", new()
 *     {
 *         FactoryName = "exampleFactoryName",
 *         GlobalParameterName = "default",
 *         Properties =
 *         {
 *             { "waitTime", new AzureNative.DataFactory.Inputs.GlobalParameterSpecificationArgs
 *             {
 *                 Type = "Int",
 *                 Value = 5,
 *             } },
 *         },
 *         ResourceGroupName = "exampleResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datafactory/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datafactory.NewGlobalParameter(ctx, "globalParameter", &datafactory.GlobalParameterArgs{
 * 			FactoryName:         pulumi.String("exampleFactoryName"),
 * 			GlobalParameterName: pulumi.String("default"),
 * 			Properties: datafactory.GlobalParameterSpecificationMap{
 * 				"waitTime": &datafactory.GlobalParameterSpecificationArgs{
 * 					Type:  pulumi.String("Int"),
 * 					Value: pulumi.Any(5),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("exampleResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datafactory.GlobalParameter;
 * import com.pulumi.azurenative.datafactory.GlobalParameterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var globalParameter = new GlobalParameter("globalParameter", GlobalParameterArgs.builder()
 *             .factoryName("exampleFactoryName")
 *             .globalParameterName("default")
 *             .properties(Map.of("waitTime", Map.ofEntries(
 *                 Map.entry("type", "Int"),
 *                 Map.entry("value", 5)
 *             )))
 *             .resourceGroupName("exampleResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### GlobalParameters_Update
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var globalParameter = new AzureNative.DataFactory.GlobalParameter("globalParameter", new()
 *     {
 *         FactoryName = "exampleFactoryName",
 *         GlobalParameterName = "default",
 *         Properties =
 *         {
 *             { "waitTime", new AzureNative.DataFactory.Inputs.GlobalParameterSpecificationArgs
 *             {
 *                 Type = "Int",
 *                 Value = 5,
 *             } },
 *         },
 *         ResourceGroupName = "exampleResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datafactory/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datafactory.NewGlobalParameter(ctx, "globalParameter", &datafactory.GlobalParameterArgs{
 * 			FactoryName:         pulumi.String("exampleFactoryName"),
 * 			GlobalParameterName: pulumi.String("default"),
 * 			Properties: datafactory.GlobalParameterSpecificationMap{
 * 				"waitTime": &datafactory.GlobalParameterSpecificationArgs{
 * 					Type:  pulumi.String("Int"),
 * 					Value: pulumi.Any(5),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("exampleResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datafactory.GlobalParameter;
 * import com.pulumi.azurenative.datafactory.GlobalParameterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var globalParameter = new GlobalParameter("globalParameter", GlobalParameterArgs.builder()
 *             .factoryName("exampleFactoryName")
 *             .globalParameterName("default")
 *             .properties(Map.of("waitTime", Map.ofEntries(
 *                 Map.entry("type", "Int"),
 *                 Map.entry("value", 5)
 *             )))
 *             .resourceGroupName("exampleResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:datafactory:GlobalParameter default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/globalParameters/{globalParameterName}
 * ```
 */
public class GlobalParameter internal constructor(
    override val javaResource: com.pulumi.azurenative.datafactory.GlobalParameter,
) : KotlinCustomResource(javaResource, GlobalParameterMapper) {
    /**
     * Etag identifies change in the resource.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * The resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Properties of the global parameter.
     */
    public val properties: Output<Map<String, GlobalParameterSpecificationResponse>>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value.let({ args0 -> toKotlin(args0) }))
            }).toMap()
        })

    /**
     * The resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object GlobalParameterMapper : ResourceMapper<GlobalParameter> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.datafactory.GlobalParameter::class == javaResource::class

    override fun map(javaResource: Resource): GlobalParameter = GlobalParameter(
        javaResource as
            com.pulumi.azurenative.datafactory.GlobalParameter,
    )
}

/**
 * @see [GlobalParameter].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [GlobalParameter].
 */
public suspend fun globalParameter(
    name: String,
    block: suspend GlobalParameterResourceBuilder.() -> Unit,
): GlobalParameter {
    val builder = GlobalParameterResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [GlobalParameter].
 * @param name The _unique_ name of the resulting resource.
 */
public fun globalParameter(name: String): GlobalParameter {
    val builder = GlobalParameterResourceBuilder()
    builder.name(name)
    return builder.build()
}
