@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin

import com.pulumi.azurenative.datafactory.kotlin.outputs.ParameterSpecificationResponse
import com.pulumi.azurenative.datafactory.kotlin.outputs.PipelinePolicyResponse
import com.pulumi.azurenative.datafactory.kotlin.outputs.PipelineResponseFolder
import com.pulumi.azurenative.datafactory.kotlin.outputs.VariableSpecificationResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.datafactory.kotlin.outputs.ParameterSpecificationResponse.Companion.toKotlin as parameterSpecificationResponseToKotlin
import com.pulumi.azurenative.datafactory.kotlin.outputs.PipelinePolicyResponse.Companion.toKotlin as pipelinePolicyResponseToKotlin
import com.pulumi.azurenative.datafactory.kotlin.outputs.PipelineResponseFolder.Companion.toKotlin as pipelineResponseFolderToKotlin
import com.pulumi.azurenative.datafactory.kotlin.outputs.VariableSpecificationResponse.Companion.toKotlin as variableSpecificationResponseToKotlin

/**
 * Builder for [Pipeline].
 */
@PulumiTagMarker
public class PipelineResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PipelineArgs = PipelineArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PipelineArgsBuilder.() -> Unit) {
        val builder = PipelineArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Pipeline {
        val builtJavaResource = com.pulumi.azurenative.datafactory.Pipeline(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Pipeline(builtJavaResource)
    }
}

/**
 * Pipeline resource type.
 * Azure REST API version: 2018-06-01. Prior API version in Azure Native 1.x: 2018-06-01.
 */
public class Pipeline internal constructor(
    override val javaResource: com.pulumi.azurenative.datafactory.Pipeline,
) : KotlinCustomResource(javaResource, PipelineMapper) {
    /**
     * List of activities in pipeline.
     */
    public val activities: Output<List<Any>>?
        get() = javaResource.activities().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * List of tags that can be used for describing the Pipeline.
     */
    public val annotations: Output<List<Any>>?
        get() = javaResource.annotations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * The max number of concurrent runs for the pipeline.
     */
    public val concurrency: Output<Int>?
        get() = javaResource.concurrency().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The description of the pipeline.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Etag identifies change in the resource.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * The folder that this Pipeline is in. If not specified, Pipeline will appear at the root level.
     */
    public val folder: Output<PipelineResponseFolder>?
        get() = javaResource.folder().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    pipelineResponseFolderToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * List of parameters for pipeline.
     */
    public val parameters: Output<Map<String, ParameterSpecificationResponse>>?
        get() = javaResource.parameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(
                        args0.value.let({ args0 ->
                            parameterSpecificationResponseToKotlin(args0)
                        }),
                    )
                }).toMap()
            }).orElse(null)
        })

    /**
     * Pipeline Policy.
     */
    public val policy: Output<PipelinePolicyResponse>?
        get() = javaResource.policy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    pipelinePolicyResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Dimensions emitted by Pipeline.
     */
    public val runDimensions: Output<Map<String, Any>>?
        get() = javaResource.runDimensions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
            }).orElse(null)
        })

    /**
     * The resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * List of variables for pipeline.
     */
    public val variables: Output<Map<String, VariableSpecificationResponse>>?
        get() = javaResource.variables().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(
                        args0.value.let({ args0 ->
                            variableSpecificationResponseToKotlin(args0)
                        }),
                    )
                }).toMap()
            }).orElse(null)
        })
}

public object PipelineMapper : ResourceMapper<Pipeline> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.datafactory.Pipeline::class == javaResource::class

    override fun map(javaResource: Resource): Pipeline = Pipeline(
        javaResource as
            com.pulumi.azurenative.datafactory.Pipeline,
    )
}

/**
 * @see [Pipeline].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Pipeline].
 */
public suspend fun pipeline(name: String, block: suspend PipelineResourceBuilder.() -> Unit):
    Pipeline {
    val builder = PipelineResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Pipeline].
 * @param name The _unique_ name of the resulting resource.
 */
public fun pipeline(name: String): Pipeline {
    val builder = PipelineResourceBuilder()
    builder.name(name)
    return builder.build()
}
