@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin

import com.pulumi.azurenative.datafactory.PrivateEndpointConnectionArgs.builder
import com.pulumi.azurenative.datafactory.kotlin.inputs.PrivateLinkConnectionApprovalRequestArgs
import com.pulumi.azurenative.datafactory.kotlin.inputs.PrivateLinkConnectionApprovalRequestArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Private Endpoint Connection ARM resource.
 * Azure REST API version: 2018-06-01. Prior API version in Azure Native 1.x: 2018-06-01.
 * ## Example Usage
 * ### Approves or rejects a private endpoint connection for a factory.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateEndpointConnection = new AzureNative.DataFactory.PrivateEndpointConnection("privateEndpointConnection", new()
 *     {
 *         FactoryName = "exampleFactoryName",
 *         PrivateEndpointConnectionName = "connection",
 *         Properties = new AzureNative.DataFactory.Inputs.PrivateLinkConnectionApprovalRequestArgs
 *         {
 *             PrivateEndpoint = new AzureNative.DataFactory.Inputs.PrivateEndpointArgs
 *             {
 *                 Id = "/subscriptions/12345678-1234-1234-1234-12345678abc/resourceGroups/exampleResourceGroup/providers/Microsoft.DataFactory/factories/exampleFactoryName/privateEndpoints/myPrivateEndpoint",
 *             },
 *             PrivateLinkServiceConnectionState = new AzureNative.DataFactory.Inputs.PrivateLinkConnectionStateArgs
 *             {
 *                 ActionsRequired = "",
 *                 Description = "Approved by admin.",
 *                 Status = "Approved",
 *             },
 *         },
 *         ResourceGroupName = "exampleResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datafactory/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datafactory.NewPrivateEndpointConnection(ctx, "privateEndpointConnection", &datafactory.PrivateEndpointConnectionArgs{
 * 			FactoryName:                   pulumi.String("exampleFactoryName"),
 * 			PrivateEndpointConnectionName: pulumi.String("connection"),
 * 			Properties: datafactory.RemotePrivateEndpointConnectionResponse{
 * 				PrivateEndpoint: &datafactory.PrivateEndpointArgs{
 * 					Id: pulumi.String("/subscriptions/12345678-1234-1234-1234-12345678abc/resourceGroups/exampleResourceGroup/providers/Microsoft.DataFactory/factories/exampleFactoryName/privateEndpoints/myPrivateEndpoint"),
 * 				},
 * 				PrivateLinkServiceConnectionState: &datafactory.PrivateLinkConnectionStateArgs{
 * 					ActionsRequired: pulumi.String(""),
 * 					Description:     pulumi.String("Approved by admin."),
 * 					Status:          pulumi.String("Approved"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("exampleResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datafactory.PrivateEndpointConnection;
 * import com.pulumi.azurenative.datafactory.PrivateEndpointConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateEndpointConnection = new PrivateEndpointConnection("privateEndpointConnection", PrivateEndpointConnectionArgs.builder()
 *             .factoryName("exampleFactoryName")
 *             .privateEndpointConnectionName("connection")
 *             .properties(Map.ofEntries(
 *                 Map.entry("privateEndpoint", Map.of("id", "/subscriptions/12345678-1234-1234-1234-12345678abc/resourceGroups/exampleResourceGroup/providers/Microsoft.DataFactory/factories/exampleFactoryName/privateEndpoints/myPrivateEndpoint")),
 *                 Map.entry("privateLinkServiceConnectionState", Map.ofEntries(
 *                     Map.entry("actionsRequired", ""),
 *                     Map.entry("description", "Approved by admin."),
 *                     Map.entry("status", "Approved")
 *                 ))
 *             ))
 *             .resourceGroupName("exampleResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:datafactory:PrivateEndpointConnection exampleFactoryName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/privateEndpointConnections/{privateEndpointConnectionName}
 * ```
 * @property factoryName The factory name.
 * @property privateEndpointConnectionName The private endpoint connection name.
 * @property properties Core resource properties
 * @property resourceGroupName The resource group name.
 */
public data class PrivateEndpointConnectionArgs(
    public val factoryName: Output<String>? = null,
    public val privateEndpointConnectionName: Output<String>? = null,
    public val properties: Output<PrivateLinkConnectionApprovalRequestArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.PrivateEndpointConnectionArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.PrivateEndpointConnectionArgs =
        com.pulumi.azurenative.datafactory.PrivateEndpointConnectionArgs.builder()
            .factoryName(factoryName?.applyValue({ args0 -> args0 }))
            .privateEndpointConnectionName(privateEndpointConnectionName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PrivateEndpointConnectionArgs].
 */
@PulumiTagMarker
public class PrivateEndpointConnectionArgsBuilder internal constructor() {
    private var factoryName: Output<String>? = null

    private var privateEndpointConnectionName: Output<String>? = null

    private var properties: Output<PrivateLinkConnectionApprovalRequestArgs>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value The factory name.
     */
    @JvmName("sgfglbvndbhlvewx")
    public suspend fun factoryName(`value`: Output<String>) {
        this.factoryName = value
    }

    /**
     * @param value The private endpoint connection name.
     */
    @JvmName("jeugnmrjigdpcwyv")
    public suspend fun privateEndpointConnectionName(`value`: Output<String>) {
        this.privateEndpointConnectionName = value
    }

    /**
     * @param value Core resource properties
     */
    @JvmName("fdkpgvroffjkvldi")
    public suspend fun properties(`value`: Output<PrivateLinkConnectionApprovalRequestArgs>) {
        this.properties = value
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("omttecbtgafqiplg")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The factory name.
     */
    @JvmName("ugsrotlmrpokmlve")
    public suspend fun factoryName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.factoryName = mapped
    }

    /**
     * @param value The private endpoint connection name.
     */
    @JvmName("ywbebkvpqumhuxwa")
    public suspend fun privateEndpointConnectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateEndpointConnectionName = mapped
    }

    /**
     * @param value Core resource properties
     */
    @JvmName("jycyekpbsiiwngge")
    public suspend fun properties(`value`: PrivateLinkConnectionApprovalRequestArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Core resource properties
     */
    @JvmName("uhcbtdmrccyspchs")
    public suspend
    fun properties(argument: suspend PrivateLinkConnectionApprovalRequestArgsBuilder.() -> Unit) {
        val toBeMapped = PrivateLinkConnectionApprovalRequestArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("ulcjbavbxyyynnnq")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): PrivateEndpointConnectionArgs = PrivateEndpointConnectionArgs(
        factoryName = factoryName,
        privateEndpointConnectionName = privateEndpointConnectionName,
        properties = properties,
        resourceGroupName = resourceGroupName,
    )
}
