@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.AmazonMWSLinkedServiceArgs.builder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Amazon Marketplace Web Service linked service.
 * @property accessKeyId The access key id used to access data.
 * @property annotations List of tags that can be used for describing the linked service.
 * @property connectVia The integration runtime reference.
 * @property description Linked service description.
 * @property encryptedCredential The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
 * @property endpoint The endpoint of the Amazon MWS server, (i.e. mws.amazonservices.com)
 * @property marketplaceID The Amazon Marketplace ID you want to retrieve data from. To retrieve data from multiple Marketplace IDs, separate them with a comma (,). (i.e. A2EUQ1WTGCTBG2)
 * @property mwsAuthToken The Amazon MWS authentication token.
 * @property parameters Parameters for linked service.
 * @property secretKey The secret key used to access data.
 * @property sellerID The Amazon seller ID.
 * @property type Type of linked service.
 * Expected value is 'AmazonMWS'.
 * @property useEncryptedEndpoints Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true.
 * @property useHostVerification Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting over SSL. The default value is true.
 * @property usePeerVerification Specifies whether to verify the identity of the server when connecting over SSL. The default value is true.
 */
public data class AmazonMWSLinkedServiceArgs(
    public val accessKeyId: Output<Any>,
    public val annotations: Output<List<Any>>? = null,
    public val connectVia: Output<IntegrationRuntimeReferenceArgs>? = null,
    public val description: Output<String>? = null,
    public val encryptedCredential: Output<String>? = null,
    public val endpoint: Output<Any>,
    public val marketplaceID: Output<Any>,
    public val mwsAuthToken: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? =
        null,
    public val parameters: Output<Map<String, ParameterSpecificationArgs>>? = null,
    public val secretKey: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null,
    public val sellerID: Output<Any>,
    public val type: Output<String>,
    public val useEncryptedEndpoints: Output<Any>? = null,
    public val useHostVerification: Output<Any>? = null,
    public val usePeerVerification: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.AmazonMWSLinkedServiceArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.AmazonMWSLinkedServiceArgs =
        com.pulumi.azurenative.datafactory.inputs.AmazonMWSLinkedServiceArgs.builder()
            .accessKeyId(accessKeyId.applyValue({ args0 -> args0 }))
            .annotations(annotations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .connectVia(connectVia?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .encryptedCredential(encryptedCredential?.applyValue({ args0 -> args0 }))
            .endpoint(endpoint.applyValue({ args0 -> args0 }))
            .marketplaceID(marketplaceID.applyValue({ args0 -> args0 }))
            .mwsAuthToken(
                mwsAuthToken?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .secretKey(
                secretKey?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .sellerID(sellerID.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .useEncryptedEndpoints(useEncryptedEndpoints?.applyValue({ args0 -> args0 }))
            .useHostVerification(useHostVerification?.applyValue({ args0 -> args0 }))
            .usePeerVerification(usePeerVerification?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AmazonMWSLinkedServiceArgs].
 */
@PulumiTagMarker
public class AmazonMWSLinkedServiceArgsBuilder internal constructor() {
    private var accessKeyId: Output<Any>? = null

    private var annotations: Output<List<Any>>? = null

    private var connectVia: Output<IntegrationRuntimeReferenceArgs>? = null

    private var description: Output<String>? = null

    private var encryptedCredential: Output<String>? = null

    private var endpoint: Output<Any>? = null

    private var marketplaceID: Output<Any>? = null

    private var mwsAuthToken: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? =
        null

    private var parameters: Output<Map<String, ParameterSpecificationArgs>>? = null

    private var secretKey: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null

    private var sellerID: Output<Any>? = null

    private var type: Output<String>? = null

    private var useEncryptedEndpoints: Output<Any>? = null

    private var useHostVerification: Output<Any>? = null

    private var usePeerVerification: Output<Any>? = null

    /**
     * @param value The access key id used to access data.
     */
    @JvmName("nemqctfdbfslnyiy")
    public suspend fun accessKeyId(`value`: Output<Any>) {
        this.accessKeyId = value
    }

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("uaruxxyplsnguhwl")
    public suspend fun annotations(`value`: Output<List<Any>>) {
        this.annotations = value
    }

    @JvmName("ejluuufwwqingemx")
    public suspend fun annotations(vararg values: Output<Any>) {
        this.annotations = Output.all(values.asList())
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("qwtvcrafegbfjiug")
    public suspend fun annotations(values: List<Output<Any>>) {
        this.annotations = Output.all(values)
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("yollamsvngxcdngr")
    public suspend fun connectVia(`value`: Output<IntegrationRuntimeReferenceArgs>) {
        this.connectVia = value
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("egnjwndasjnkbanf")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("gambhgltinnvjcvn")
    public suspend fun encryptedCredential(`value`: Output<String>) {
        this.encryptedCredential = value
    }

    /**
     * @param value The endpoint of the Amazon MWS server, (i.e. mws.amazonservices.com)
     */
    @JvmName("kbjyespxdqnjfmpk")
    public suspend fun endpoint(`value`: Output<Any>) {
        this.endpoint = value
    }

    /**
     * @param value The Amazon Marketplace ID you want to retrieve data from. To retrieve data from multiple Marketplace IDs, separate them with a comma (,). (i.e. A2EUQ1WTGCTBG2)
     */
    @JvmName("mjxbsfmxqboptjsa")
    public suspend fun marketplaceID(`value`: Output<Any>) {
        this.marketplaceID = value
    }

    /**
     * @param value The Amazon MWS authentication token.
     */
    @JvmName("iliiemxddninyxqi")
    public suspend
    fun mwsAuthToken(`value`: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>) {
        this.mwsAuthToken = value
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("mrvosrdpkerbkojx")
    public suspend fun parameters(`value`: Output<Map<String, ParameterSpecificationArgs>>) {
        this.parameters = value
    }

    /**
     * @param value The secret key used to access data.
     */
    @JvmName("lysruvovdcgfjfjr")
    public suspend
    fun secretKey(`value`: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>) {
        this.secretKey = value
    }

    /**
     * @param value The Amazon seller ID.
     */
    @JvmName("flwmdlfpgdpawnga")
    public suspend fun sellerID(`value`: Output<Any>) {
        this.sellerID = value
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'AmazonMWS'.
     */
    @JvmName("wbhitpvexxdggeqa")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true.
     */
    @JvmName("vnllncgtslffmxmm")
    public suspend fun useEncryptedEndpoints(`value`: Output<Any>) {
        this.useEncryptedEndpoints = value
    }

    /**
     * @param value Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting over SSL. The default value is true.
     */
    @JvmName("ptgwriqfqtghkmhj")
    public suspend fun useHostVerification(`value`: Output<Any>) {
        this.useHostVerification = value
    }

    /**
     * @param value Specifies whether to verify the identity of the server when connecting over SSL. The default value is true.
     */
    @JvmName("vpipapowilmjkaiw")
    public suspend fun usePeerVerification(`value`: Output<Any>) {
        this.usePeerVerification = value
    }

    /**
     * @param value The access key id used to access data.
     */
    @JvmName("drnguuwdyxrwnysf")
    public suspend fun accessKeyId(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accessKeyId = mapped
    }

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("lxopodibojicppfk")
    public suspend fun annotations(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("suoekgdrlrirwomt")
    public suspend fun annotations(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("ogaprlhislafbdoc")
    public suspend fun connectVia(`value`: IntegrationRuntimeReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectVia = mapped
    }

    /**
     * @param argument The integration runtime reference.
     */
    @JvmName("cfoynyxbpunhartu")
    public suspend
    fun connectVia(argument: suspend IntegrationRuntimeReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = IntegrationRuntimeReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.connectVia = mapped
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("vsnqhpqonomndalh")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("xhtabebnvwdqyelv")
    public suspend fun encryptedCredential(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptedCredential = mapped
    }

    /**
     * @param value The endpoint of the Amazon MWS server, (i.e. mws.amazonservices.com)
     */
    @JvmName("uemyqxewllamrlxj")
    public suspend fun endpoint(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpoint = mapped
    }

    /**
     * @param value The Amazon Marketplace ID you want to retrieve data from. To retrieve data from multiple Marketplace IDs, separate them with a comma (,). (i.e. A2EUQ1WTGCTBG2)
     */
    @JvmName("dynofqobnvbwrxof")
    public suspend fun marketplaceID(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.marketplaceID = mapped
    }

    /**
     * @param value The Amazon MWS authentication token.
     */
    @JvmName("nqtlcckoghkjwqvj")
    public suspend
    fun mwsAuthToken(`value`: Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mwsAuthToken = mapped
    }

    /**
     * @param value The Amazon MWS authentication token.
     */
    @JvmName("imdoctisvkfqnvhu")
    public fun mwsAuthToken(`value`: AzureKeyVaultSecretReferenceArgs) {
        val toBeMapped = Either.ofLeft<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mwsAuthToken = mapped
    }

    /**
     * @param value The Amazon MWS authentication token.
     */
    @JvmName("lxdcgydiylyjnuhc")
    public fun mwsAuthToken(`value`: SecureStringArgs) {
        val toBeMapped = Either.ofRight<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mwsAuthToken = mapped
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("hdpcntpoarfckpox")
    public suspend fun parameters(`value`: Map<String, ParameterSpecificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Parameters for linked service.
     */
    @JvmName("hpdccdmplvdvpbyl")
    public suspend fun parameters(
        vararg
        argument: Pair<String, suspend ParameterSpecificationArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ParameterSpecificationArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Parameters for linked service.
     */
    @JvmName("rucilwteydasutyn")
    public fun parameters(vararg values: Pair<String, ParameterSpecificationArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value The secret key used to access data.
     */
    @JvmName("yqsahyvwukkjryav")
    public suspend
    fun secretKey(`value`: Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secretKey = mapped
    }

    /**
     * @param value The secret key used to access data.
     */
    @JvmName("jshmvwcxprcudovv")
    public fun secretKey(`value`: AzureKeyVaultSecretReferenceArgs) {
        val toBeMapped = Either.ofLeft<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.secretKey = mapped
    }

    /**
     * @param value The secret key used to access data.
     */
    @JvmName("cvbawwcdvexpxocq")
    public fun secretKey(`value`: SecureStringArgs) {
        val toBeMapped = Either.ofRight<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.secretKey = mapped
    }

    /**
     * @param value The Amazon seller ID.
     */
    @JvmName("kwmnkcjtskfmmtay")
    public suspend fun sellerID(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sellerID = mapped
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'AmazonMWS'.
     */
    @JvmName("wttjuftyjhbbunie")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true.
     */
    @JvmName("duyyreyfdbakyhud")
    public suspend fun useEncryptedEndpoints(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useEncryptedEndpoints = mapped
    }

    /**
     * @param value Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting over SSL. The default value is true.
     */
    @JvmName("fvlqsavbcwhyfjyy")
    public suspend fun useHostVerification(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useHostVerification = mapped
    }

    /**
     * @param value Specifies whether to verify the identity of the server when connecting over SSL. The default value is true.
     */
    @JvmName("wnlssbtduxsaqykw")
    public suspend fun usePeerVerification(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.usePeerVerification = mapped
    }

    internal fun build(): AmazonMWSLinkedServiceArgs = AmazonMWSLinkedServiceArgs(
        accessKeyId = accessKeyId ?: throw PulumiNullFieldException("accessKeyId"),
        annotations = annotations,
        connectVia = connectVia,
        description = description,
        encryptedCredential = encryptedCredential,
        endpoint = endpoint ?: throw PulumiNullFieldException("endpoint"),
        marketplaceID = marketplaceID ?: throw PulumiNullFieldException("marketplaceID"),
        mwsAuthToken = mwsAuthToken,
        parameters = parameters,
        secretKey = secretKey,
        sellerID = sellerID ?: throw PulumiNullFieldException("sellerID"),
        type = type ?: throw PulumiNullFieldException("type"),
        useEncryptedEndpoints = useEncryptedEndpoints,
        useHostVerification = useHostVerification,
        usePeerVerification = usePeerVerification,
    )
}
