@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.AmazonRdsForSqlServerLinkedServiceArgs.builder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Amazon RDS for SQL Server linked service.
 * @property alwaysEncryptedSettings Sql always encrypted properties.
 * @property annotations List of tags that can be used for describing the linked service.
 * @property connectVia The integration runtime reference.
 * @property connectionString The connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
 * @property description Linked service description.
 * @property encryptedCredential The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
 * @property parameters Parameters for linked service.
 * @property password The on-premises Windows authentication password.
 * @property type Type of linked service.
 * Expected value is 'AmazonRdsForSqlServer'.
 * @property userName The on-premises Windows authentication user name. Type: string (or Expression with resultType string).
 */
public data class AmazonRdsForSqlServerLinkedServiceArgs(
    public val alwaysEncryptedSettings: Output<SqlAlwaysEncryptedPropertiesArgs>? = null,
    public val annotations: Output<List<Any>>? = null,
    public val connectVia: Output<IntegrationRuntimeReferenceArgs>? = null,
    public val connectionString: Output<Any>,
    public val description: Output<String>? = null,
    public val encryptedCredential: Output<String>? = null,
    public val parameters: Output<Map<String, ParameterSpecificationArgs>>? = null,
    public val password: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null,
    public val type: Output<String>,
    public val userName: Output<Any>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.AmazonRdsForSqlServerLinkedServiceArgs> {
    override fun toJava():
        com.pulumi.azurenative.datafactory.inputs.AmazonRdsForSqlServerLinkedServiceArgs =
        com.pulumi.azurenative.datafactory.inputs.AmazonRdsForSqlServerLinkedServiceArgs.builder()
            .alwaysEncryptedSettings(
                alwaysEncryptedSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .annotations(annotations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .connectVia(connectVia?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .connectionString(connectionString.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .encryptedCredential(encryptedCredential?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .password(
                password?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .type(type.applyValue({ args0 -> args0 }))
            .userName(userName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AmazonRdsForSqlServerLinkedServiceArgs].
 */
@PulumiTagMarker
public class AmazonRdsForSqlServerLinkedServiceArgsBuilder internal constructor() {
    private var alwaysEncryptedSettings: Output<SqlAlwaysEncryptedPropertiesArgs>? = null

    private var annotations: Output<List<Any>>? = null

    private var connectVia: Output<IntegrationRuntimeReferenceArgs>? = null

    private var connectionString: Output<Any>? = null

    private var description: Output<String>? = null

    private var encryptedCredential: Output<String>? = null

    private var parameters: Output<Map<String, ParameterSpecificationArgs>>? = null

    private var password: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null

    private var type: Output<String>? = null

    private var userName: Output<Any>? = null

    /**
     * @param value Sql always encrypted properties.
     */
    @JvmName("esjtnoflsfooqqdj")
    public suspend fun alwaysEncryptedSettings(`value`: Output<SqlAlwaysEncryptedPropertiesArgs>) {
        this.alwaysEncryptedSettings = value
    }

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("ucbyqujmngwvifua")
    public suspend fun annotations(`value`: Output<List<Any>>) {
        this.annotations = value
    }

    @JvmName("alatulsibeqtmrek")
    public suspend fun annotations(vararg values: Output<Any>) {
        this.annotations = Output.all(values.asList())
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("omahqyskawceptfx")
    public suspend fun annotations(values: List<Output<Any>>) {
        this.annotations = Output.all(values)
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("lhpwknlnmmujoujs")
    public suspend fun connectVia(`value`: Output<IntegrationRuntimeReferenceArgs>) {
        this.connectVia = value
    }

    /**
     * @param value The connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
     */
    @JvmName("poaihtpjxlkbamcc")
    public suspend fun connectionString(`value`: Output<Any>) {
        this.connectionString = value
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("esrvcxlovxldqxmu")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("cdedcrllpmujfgdr")
    public suspend fun encryptedCredential(`value`: Output<String>) {
        this.encryptedCredential = value
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("nfthoypqcxqgxagc")
    public suspend fun parameters(`value`: Output<Map<String, ParameterSpecificationArgs>>) {
        this.parameters = value
    }

    /**
     * @param value The on-premises Windows authentication password.
     */
    @JvmName("fdnyoarxpjfvdufb")
    public suspend
    fun password(`value`: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>) {
        this.password = value
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'AmazonRdsForSqlServer'.
     */
    @JvmName("fmqbixiksbqabcbn")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The on-premises Windows authentication user name. Type: string (or Expression with resultType string).
     */
    @JvmName("ofepxgwqxsgumdmv")
    public suspend fun userName(`value`: Output<Any>) {
        this.userName = value
    }

    /**
     * @param value Sql always encrypted properties.
     */
    @JvmName("ehboywxrpgehhttw")
    public suspend fun alwaysEncryptedSettings(`value`: SqlAlwaysEncryptedPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alwaysEncryptedSettings = mapped
    }

    /**
     * @param argument Sql always encrypted properties.
     */
    @JvmName("fsqxriupadweaoyd")
    public suspend
    fun alwaysEncryptedSettings(argument: suspend SqlAlwaysEncryptedPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = SqlAlwaysEncryptedPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.alwaysEncryptedSettings = mapped
    }

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("lxihhishwsgyrfaj")
    public suspend fun annotations(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("nvqaotwjryncdjfl")
    public suspend fun annotations(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("xkgkqqmayaextcjr")
    public suspend fun connectVia(`value`: IntegrationRuntimeReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectVia = mapped
    }

    /**
     * @param argument The integration runtime reference.
     */
    @JvmName("atbattpjdqbseytc")
    public suspend
    fun connectVia(argument: suspend IntegrationRuntimeReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = IntegrationRuntimeReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.connectVia = mapped
    }

    /**
     * @param value The connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
     */
    @JvmName("mprfwcnaxenylcmk")
    public suspend fun connectionString(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.connectionString = mapped
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("wbwxwgqkvxcxgptr")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("rjaxxeuysentefds")
    public suspend fun encryptedCredential(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptedCredential = mapped
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("dpghtloqgxxyftmr")
    public suspend fun parameters(`value`: Map<String, ParameterSpecificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Parameters for linked service.
     */
    @JvmName("ktucpnkgqssnqjbu")
    public suspend fun parameters(
        vararg
        argument: Pair<String, suspend ParameterSpecificationArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ParameterSpecificationArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Parameters for linked service.
     */
    @JvmName("whfarpijxbiipmmq")
    public fun parameters(vararg values: Pair<String, ParameterSpecificationArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value The on-premises Windows authentication password.
     */
    @JvmName("dnbnosmhpdnqlnaj")
    public suspend
    fun password(`value`: Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The on-premises Windows authentication password.
     */
    @JvmName("rsuwmfixehgbgpek")
    public fun password(`value`: AzureKeyVaultSecretReferenceArgs) {
        val toBeMapped = Either.ofLeft<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The on-premises Windows authentication password.
     */
    @JvmName("ssniosttdaoweveo")
    public fun password(`value`: SecureStringArgs) {
        val toBeMapped = Either.ofRight<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'AmazonRdsForSqlServer'.
     */
    @JvmName("iefilnmytfrhcash")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The on-premises Windows authentication user name. Type: string (or Expression with resultType string).
     */
    @JvmName("yykermltoojvufnj")
    public suspend fun userName(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userName = mapped
    }

    internal fun build(): AmazonRdsForSqlServerLinkedServiceArgs =
        AmazonRdsForSqlServerLinkedServiceArgs(
            alwaysEncryptedSettings = alwaysEncryptedSettings,
            annotations = annotations,
            connectVia = connectVia,
            connectionString = connectionString ?: throw PulumiNullFieldException("connectionString"),
            description = description,
            encryptedCredential = encryptedCredential,
            parameters = parameters,
            password = password,
            type = type ?: throw PulumiNullFieldException("type"),
            userName = userName,
        )
}
