@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.AvroWriteSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Avro write settings.
 * @property fileNamePrefix Specifies the file name pattern <fileNamePrefix>_<fileIndex>.<fileExtension> when copy from non-file based store without partitionOptions. Type: string (or Expression with resultType string).
 * @property maxRowsPerFile Limit the written file's row count to be smaller than or equal to the specified count. Type: integer (or Expression with resultType integer).
 * @property recordName Top level record name in write result, which is required in AVRO spec.
 * @property recordNamespace Record namespace in the write result.
 * @property type The write setting type.
 * Expected value is 'AvroWriteSettings'.
 */
public data class AvroWriteSettingsArgs(
    public val fileNamePrefix: Output<Any>? = null,
    public val maxRowsPerFile: Output<Any>? = null,
    public val recordName: Output<String>? = null,
    public val recordNamespace: Output<String>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.AvroWriteSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.AvroWriteSettingsArgs =
        com.pulumi.azurenative.datafactory.inputs.AvroWriteSettingsArgs.builder()
            .fileNamePrefix(fileNamePrefix?.applyValue({ args0 -> args0 }))
            .maxRowsPerFile(maxRowsPerFile?.applyValue({ args0 -> args0 }))
            .recordName(recordName?.applyValue({ args0 -> args0 }))
            .recordNamespace(recordNamespace?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AvroWriteSettingsArgs].
 */
@PulumiTagMarker
public class AvroWriteSettingsArgsBuilder internal constructor() {
    private var fileNamePrefix: Output<Any>? = null

    private var maxRowsPerFile: Output<Any>? = null

    private var recordName: Output<String>? = null

    private var recordNamespace: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value Specifies the file name pattern <fileNamePrefix>_<fileIndex>.<fileExtension> when copy from non-file based store without partitionOptions. Type: string (or Expression with resultType string).
     */
    @JvmName("jphpcqexdtghwvgt")
    public suspend fun fileNamePrefix(`value`: Output<Any>) {
        this.fileNamePrefix = value
    }

    /**
     * @param value Limit the written file's row count to be smaller than or equal to the specified count. Type: integer (or Expression with resultType integer).
     */
    @JvmName("ppgniyfqxvaxisua")
    public suspend fun maxRowsPerFile(`value`: Output<Any>) {
        this.maxRowsPerFile = value
    }

    /**
     * @param value Top level record name in write result, which is required in AVRO spec.
     */
    @JvmName("adbrgfjjoomrcfcw")
    public suspend fun recordName(`value`: Output<String>) {
        this.recordName = value
    }

    /**
     * @param value Record namespace in the write result.
     */
    @JvmName("qwupagduqvnegagr")
    public suspend fun recordNamespace(`value`: Output<String>) {
        this.recordNamespace = value
    }

    /**
     * @param value The write setting type.
     * Expected value is 'AvroWriteSettings'.
     */
    @JvmName("ywkemafqglasxmdg")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Specifies the file name pattern <fileNamePrefix>_<fileIndex>.<fileExtension> when copy from non-file based store without partitionOptions. Type: string (or Expression with resultType string).
     */
    @JvmName("jhnqccgcksafiwng")
    public suspend fun fileNamePrefix(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileNamePrefix = mapped
    }

    /**
     * @param value Limit the written file's row count to be smaller than or equal to the specified count. Type: integer (or Expression with resultType integer).
     */
    @JvmName("nuoqcfnqtascvfwn")
    public suspend fun maxRowsPerFile(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxRowsPerFile = mapped
    }

    /**
     * @param value Top level record name in write result, which is required in AVRO spec.
     */
    @JvmName("aujquqwwirfsdmti")
    public suspend fun recordName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recordName = mapped
    }

    /**
     * @param value Record namespace in the write result.
     */
    @JvmName("rhjdvmtikoerpwkh")
    public suspend fun recordNamespace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recordNamespace = mapped
    }

    /**
     * @param value The write setting type.
     * Expected value is 'AvroWriteSettings'.
     */
    @JvmName("pdywqxtkkchgcogt")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): AvroWriteSettingsArgs = AvroWriteSettingsArgs(
        fileNamePrefix = fileNamePrefix,
        maxRowsPerFile = maxRowsPerFile,
        recordName = recordName,
        recordNamespace = recordNamespace,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
