@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.AzureBlobStorageWriteSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Azure blob write settings.
 * @property blockSizeInMB Indicates the block size(MB) when writing data to blob. Type: integer (or Expression with resultType integer).
 * @property copyBehavior The type of copy behavior for copy sink.
 * @property disableMetricsCollection If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
 * @property maxConcurrentConnections The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
 * @property type The write setting type.
 * Expected value is 'AzureBlobStorageWriteSettings'.
 */
public data class AzureBlobStorageWriteSettingsArgs(
    public val blockSizeInMB: Output<Any>? = null,
    public val copyBehavior: Output<Any>? = null,
    public val disableMetricsCollection: Output<Any>? = null,
    public val maxConcurrentConnections: Output<Any>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.AzureBlobStorageWriteSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.AzureBlobStorageWriteSettingsArgs =
        com.pulumi.azurenative.datafactory.inputs.AzureBlobStorageWriteSettingsArgs.builder()
            .blockSizeInMB(blockSizeInMB?.applyValue({ args0 -> args0 }))
            .copyBehavior(copyBehavior?.applyValue({ args0 -> args0 }))
            .disableMetricsCollection(disableMetricsCollection?.applyValue({ args0 -> args0 }))
            .maxConcurrentConnections(maxConcurrentConnections?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureBlobStorageWriteSettingsArgs].
 */
@PulumiTagMarker
public class AzureBlobStorageWriteSettingsArgsBuilder internal constructor() {
    private var blockSizeInMB: Output<Any>? = null

    private var copyBehavior: Output<Any>? = null

    private var disableMetricsCollection: Output<Any>? = null

    private var maxConcurrentConnections: Output<Any>? = null

    private var type: Output<String>? = null

    /**
     * @param value Indicates the block size(MB) when writing data to blob. Type: integer (or Expression with resultType integer).
     */
    @JvmName("qhhtcagblllsmgpn")
    public suspend fun blockSizeInMB(`value`: Output<Any>) {
        this.blockSizeInMB = value
    }

    /**
     * @param value The type of copy behavior for copy sink.
     */
    @JvmName("otpisfafpvelwoje")
    public suspend fun copyBehavior(`value`: Output<Any>) {
        this.copyBehavior = value
    }

    /**
     * @param value If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("ciyvpcvetsinwxkg")
    public suspend fun disableMetricsCollection(`value`: Output<Any>) {
        this.disableMetricsCollection = value
    }

    /**
     * @param value The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
     */
    @JvmName("picqgdyddmmcyckc")
    public suspend fun maxConcurrentConnections(`value`: Output<Any>) {
        this.maxConcurrentConnections = value
    }

    /**
     * @param value The write setting type.
     * Expected value is 'AzureBlobStorageWriteSettings'.
     */
    @JvmName("setldeiasmtcokdb")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Indicates the block size(MB) when writing data to blob. Type: integer (or Expression with resultType integer).
     */
    @JvmName("dvqmufyjnhhhpsxq")
    public suspend fun blockSizeInMB(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blockSizeInMB = mapped
    }

    /**
     * @param value The type of copy behavior for copy sink.
     */
    @JvmName("tcfssxtoiimyyhog")
    public suspend fun copyBehavior(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.copyBehavior = mapped
    }

    /**
     * @param value If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("gfqqcpggovsymsdb")
    public suspend fun disableMetricsCollection(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableMetricsCollection = mapped
    }

    /**
     * @param value The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
     */
    @JvmName("ffapsakqqyrkhdrg")
    public suspend fun maxConcurrentConnections(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxConcurrentConnections = mapped
    }

    /**
     * @param value The write setting type.
     * Expected value is 'AzureBlobStorageWriteSettings'.
     */
    @JvmName("ycnkayydvrkaaxmm")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): AzureBlobStorageWriteSettingsArgs = AzureBlobStorageWriteSettingsArgs(
        blockSizeInMB = blockSizeInMB,
        copyBehavior = copyBehavior,
        disableMetricsCollection = disableMetricsCollection,
        maxConcurrentConnections = maxConcurrentConnections,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
