@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.AzureDataLakeAnalyticsLinkedServiceArgs.builder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Azure Data Lake Analytics linked service.
 * @property accountName The Azure Data Lake Analytics account name. Type: string (or Expression with resultType string).
 * @property annotations List of tags that can be used for describing the linked service.
 * @property connectVia The integration runtime reference.
 * @property dataLakeAnalyticsUri Azure Data Lake Analytics URI Type: string (or Expression with resultType string).
 * @property description Linked service description.
 * @property encryptedCredential The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
 * @property parameters Parameters for linked service.
 * @property resourceGroupName Data Lake Analytics account resource group name (if different from Data Factory account). Type: string (or Expression with resultType string).
 * @property servicePrincipalId The ID of the application used to authenticate against the Azure Data Lake Analytics account. Type: string (or Expression with resultType string).
 * @property servicePrincipalKey The Key of the application used to authenticate against the Azure Data Lake Analytics account.
 * @property subscriptionId Data Lake Analytics account subscription ID (if different from Data Factory account). Type: string (or Expression with resultType string).
 * @property tenant The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string).
 * @property type Type of linked service.
 * Expected value is 'AzureDataLakeAnalytics'.
 */
public data class AzureDataLakeAnalyticsLinkedServiceArgs(
    public val accountName: Output<Any>,
    public val annotations: Output<List<Any>>? = null,
    public val connectVia: Output<IntegrationRuntimeReferenceArgs>? = null,
    public val dataLakeAnalyticsUri: Output<Any>? = null,
    public val description: Output<String>? = null,
    public val encryptedCredential: Output<String>? = null,
    public val parameters: Output<Map<String, ParameterSpecificationArgs>>? = null,
    public val resourceGroupName: Output<Any>? = null,
    public val servicePrincipalId: Output<Any>? = null,
    public val servicePrincipalKey:
    Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null,
    public val subscriptionId: Output<Any>? = null,
    public val tenant: Output<Any>,
    public val type: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.AzureDataLakeAnalyticsLinkedServiceArgs> {
    override fun toJava():
        com.pulumi.azurenative.datafactory.inputs.AzureDataLakeAnalyticsLinkedServiceArgs =
        com.pulumi.azurenative.datafactory.inputs.AzureDataLakeAnalyticsLinkedServiceArgs.builder()
            .accountName(accountName.applyValue({ args0 -> args0 }))
            .annotations(annotations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .connectVia(connectVia?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .dataLakeAnalyticsUri(dataLakeAnalyticsUri?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .encryptedCredential(encryptedCredential?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .servicePrincipalId(servicePrincipalId?.applyValue({ args0 -> args0 }))
            .servicePrincipalKey(
                servicePrincipalKey?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .subscriptionId(subscriptionId?.applyValue({ args0 -> args0 }))
            .tenant(tenant.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureDataLakeAnalyticsLinkedServiceArgs].
 */
@PulumiTagMarker
public class AzureDataLakeAnalyticsLinkedServiceArgsBuilder internal constructor() {
    private var accountName: Output<Any>? = null

    private var annotations: Output<List<Any>>? = null

    private var connectVia: Output<IntegrationRuntimeReferenceArgs>? = null

    private var dataLakeAnalyticsUri: Output<Any>? = null

    private var description: Output<String>? = null

    private var encryptedCredential: Output<String>? = null

    private var parameters: Output<Map<String, ParameterSpecificationArgs>>? = null

    private var resourceGroupName: Output<Any>? = null

    private var servicePrincipalId: Output<Any>? = null

    private var servicePrincipalKey:
        Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null

    private var subscriptionId: Output<Any>? = null

    private var tenant: Output<Any>? = null

    private var type: Output<String>? = null

    /**
     * @param value The Azure Data Lake Analytics account name. Type: string (or Expression with resultType string).
     */
    @JvmName("tvyxmthpmbjhnuta")
    public suspend fun accountName(`value`: Output<Any>) {
        this.accountName = value
    }

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("rygxfxlfmdjekxwt")
    public suspend fun annotations(`value`: Output<List<Any>>) {
        this.annotations = value
    }

    @JvmName("snqecrqovaeinjlq")
    public suspend fun annotations(vararg values: Output<Any>) {
        this.annotations = Output.all(values.asList())
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("cjummbppauqehyxv")
    public suspend fun annotations(values: List<Output<Any>>) {
        this.annotations = Output.all(values)
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("vbrqdfcjovkqrfpt")
    public suspend fun connectVia(`value`: Output<IntegrationRuntimeReferenceArgs>) {
        this.connectVia = value
    }

    /**
     * @param value Azure Data Lake Analytics URI Type: string (or Expression with resultType string).
     */
    @JvmName("qgnhbsjlbefygmbl")
    public suspend fun dataLakeAnalyticsUri(`value`: Output<Any>) {
        this.dataLakeAnalyticsUri = value
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("chvawsaduslcluoh")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("pwvimqmdsgltbgqs")
    public suspend fun encryptedCredential(`value`: Output<String>) {
        this.encryptedCredential = value
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("hntgsetskwqvwbta")
    public suspend fun parameters(`value`: Output<Map<String, ParameterSpecificationArgs>>) {
        this.parameters = value
    }

    /**
     * @param value Data Lake Analytics account resource group name (if different from Data Factory account). Type: string (or Expression with resultType string).
     */
    @JvmName("lminbkfsqgrosvjx")
    public suspend fun resourceGroupName(`value`: Output<Any>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The ID of the application used to authenticate against the Azure Data Lake Analytics account. Type: string (or Expression with resultType string).
     */
    @JvmName("bmktsachtlpftmsb")
    public suspend fun servicePrincipalId(`value`: Output<Any>) {
        this.servicePrincipalId = value
    }

    /**
     * @param value The Key of the application used to authenticate against the Azure Data Lake Analytics account.
     */
    @JvmName("kuyxfosopkprihyl")
    public suspend
    fun servicePrincipalKey(`value`: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>) {
        this.servicePrincipalKey = value
    }

    /**
     * @param value Data Lake Analytics account subscription ID (if different from Data Factory account). Type: string (or Expression with resultType string).
     */
    @JvmName("lodyqkxxqgrjeuhg")
    public suspend fun subscriptionId(`value`: Output<Any>) {
        this.subscriptionId = value
    }

    /**
     * @param value The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string).
     */
    @JvmName("imhtjqihsekopejf")
    public suspend fun tenant(`value`: Output<Any>) {
        this.tenant = value
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'AzureDataLakeAnalytics'.
     */
    @JvmName("hxfawcvurklfdnct")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The Azure Data Lake Analytics account name. Type: string (or Expression with resultType string).
     */
    @JvmName("ysfiivspiekgkpot")
    public suspend fun accountName(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("htvthbdiqwrvgaiu")
    public suspend fun annotations(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("itcffiyxayrvtlyv")
    public suspend fun annotations(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("gpoycbuklwwtofvy")
    public suspend fun connectVia(`value`: IntegrationRuntimeReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectVia = mapped
    }

    /**
     * @param argument The integration runtime reference.
     */
    @JvmName("tefregtvcvurrdcj")
    public suspend
    fun connectVia(argument: suspend IntegrationRuntimeReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = IntegrationRuntimeReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.connectVia = mapped
    }

    /**
     * @param value Azure Data Lake Analytics URI Type: string (or Expression with resultType string).
     */
    @JvmName("plvtpbopcmrhpgcg")
    public suspend fun dataLakeAnalyticsUri(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataLakeAnalyticsUri = mapped
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("rdvledswcyuwthpu")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("bbwndbuptwlyaaim")
    public suspend fun encryptedCredential(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptedCredential = mapped
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("ausslrgmjdqwxefc")
    public suspend fun parameters(`value`: Map<String, ParameterSpecificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Parameters for linked service.
     */
    @JvmName("scyuqbgrtaaqjfto")
    public suspend fun parameters(
        vararg
        argument: Pair<String, suspend ParameterSpecificationArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ParameterSpecificationArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Parameters for linked service.
     */
    @JvmName("lmbeadkfuojggqiv")
    public fun parameters(vararg values: Pair<String, ParameterSpecificationArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value Data Lake Analytics account resource group name (if different from Data Factory account). Type: string (or Expression with resultType string).
     */
    @JvmName("srqmwxregrhownrx")
    public suspend fun resourceGroupName(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The ID of the application used to authenticate against the Azure Data Lake Analytics account. Type: string (or Expression with resultType string).
     */
    @JvmName("hdcbwrrwthunyurp")
    public suspend fun servicePrincipalId(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.servicePrincipalId = mapped
    }

    /**
     * @param value The Key of the application used to authenticate against the Azure Data Lake Analytics account.
     */
    @JvmName("hdfqqcypkbkminxv")
    public suspend
    fun servicePrincipalKey(`value`: Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.servicePrincipalKey = mapped
    }

    /**
     * @param value The Key of the application used to authenticate against the Azure Data Lake Analytics account.
     */
    @JvmName("pecqlfxrsutqhsfu")
    public fun servicePrincipalKey(`value`: AzureKeyVaultSecretReferenceArgs) {
        val toBeMapped = Either.ofLeft<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.servicePrincipalKey = mapped
    }

    /**
     * @param value The Key of the application used to authenticate against the Azure Data Lake Analytics account.
     */
    @JvmName("ewkwwfxwmtcbygvp")
    public fun servicePrincipalKey(`value`: SecureStringArgs) {
        val toBeMapped = Either.ofRight<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.servicePrincipalKey = mapped
    }

    /**
     * @param value Data Lake Analytics account subscription ID (if different from Data Factory account). Type: string (or Expression with resultType string).
     */
    @JvmName("xtifaepfqpgdgypk")
    public suspend fun subscriptionId(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subscriptionId = mapped
    }

    /**
     * @param value The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string).
     */
    @JvmName("fsnbgefqmxxwfelm")
    public suspend fun tenant(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tenant = mapped
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'AzureDataLakeAnalytics'.
     */
    @JvmName("dfttpwapidusvucf")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): AzureDataLakeAnalyticsLinkedServiceArgs =
        AzureDataLakeAnalyticsLinkedServiceArgs(
            accountName = accountName ?: throw PulumiNullFieldException("accountName"),
            annotations = annotations,
            connectVia = connectVia,
            dataLakeAnalyticsUri = dataLakeAnalyticsUri,
            description = description,
            encryptedCredential = encryptedCredential,
            parameters = parameters,
            resourceGroupName = resourceGroupName,
            servicePrincipalId = servicePrincipalId,
            servicePrincipalKey = servicePrincipalKey,
            subscriptionId = subscriptionId,
            tenant = tenant ?: throw PulumiNullFieldException("tenant"),
            type = type ?: throw PulumiNullFieldException("type"),
        )
}
