@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.AzureFileStorageWriteSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Azure File Storage write settings.
 * @property copyBehavior The type of copy behavior for copy sink.
 * @property disableMetricsCollection If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
 * @property maxConcurrentConnections The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
 * @property type The write setting type.
 * Expected value is 'AzureFileStorageWriteSettings'.
 */
public data class AzureFileStorageWriteSettingsArgs(
    public val copyBehavior: Output<Any>? = null,
    public val disableMetricsCollection: Output<Any>? = null,
    public val maxConcurrentConnections: Output<Any>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.AzureFileStorageWriteSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.AzureFileStorageWriteSettingsArgs =
        com.pulumi.azurenative.datafactory.inputs.AzureFileStorageWriteSettingsArgs.builder()
            .copyBehavior(copyBehavior?.applyValue({ args0 -> args0 }))
            .disableMetricsCollection(disableMetricsCollection?.applyValue({ args0 -> args0 }))
            .maxConcurrentConnections(maxConcurrentConnections?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureFileStorageWriteSettingsArgs].
 */
@PulumiTagMarker
public class AzureFileStorageWriteSettingsArgsBuilder internal constructor() {
    private var copyBehavior: Output<Any>? = null

    private var disableMetricsCollection: Output<Any>? = null

    private var maxConcurrentConnections: Output<Any>? = null

    private var type: Output<String>? = null

    /**
     * @param value The type of copy behavior for copy sink.
     */
    @JvmName("oggauxsfcxcguhaa")
    public suspend fun copyBehavior(`value`: Output<Any>) {
        this.copyBehavior = value
    }

    /**
     * @param value If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("kyckuakhwilgosge")
    public suspend fun disableMetricsCollection(`value`: Output<Any>) {
        this.disableMetricsCollection = value
    }

    /**
     * @param value The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
     */
    @JvmName("iwaijrqueakpeehe")
    public suspend fun maxConcurrentConnections(`value`: Output<Any>) {
        this.maxConcurrentConnections = value
    }

    /**
     * @param value The write setting type.
     * Expected value is 'AzureFileStorageWriteSettings'.
     */
    @JvmName("tmwdhpvipwfirgrq")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The type of copy behavior for copy sink.
     */
    @JvmName("yfohiillpnenuayd")
    public suspend fun copyBehavior(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.copyBehavior = mapped
    }

    /**
     * @param value If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("vbjlrlxximoeghrp")
    public suspend fun disableMetricsCollection(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableMetricsCollection = mapped
    }

    /**
     * @param value The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
     */
    @JvmName("lmxxiahmbvgsvfxr")
    public suspend fun maxConcurrentConnections(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxConcurrentConnections = mapped
    }

    /**
     * @param value The write setting type.
     * Expected value is 'AzureFileStorageWriteSettings'.
     */
    @JvmName("wthwlfmaskncctgs")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): AzureFileStorageWriteSettingsArgs = AzureFileStorageWriteSettingsArgs(
        copyBehavior = copyBehavior,
        disableMetricsCollection = disableMetricsCollection,
        maxConcurrentConnections = maxConcurrentConnections,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
