@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.AzureMLServiceLinkedServiceArgs.builder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Azure ML Service linked service.
 * @property annotations List of tags that can be used for describing the linked service.
 * @property authentication Type of authentication (Required to specify MSI) used to connect to AzureML. Type: string (or Expression with resultType string).
 * @property connectVia The integration runtime reference.
 * @property description Linked service description.
 * @property encryptedCredential The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
 * @property mlWorkspaceName Azure ML Service workspace name. Type: string (or Expression with resultType string).
 * @property parameters Parameters for linked service.
 * @property resourceGroupName Azure ML Service workspace resource group name. Type: string (or Expression with resultType string).
 * @property servicePrincipalId The ID of the service principal used to authenticate against the endpoint of a published Azure ML Service pipeline. Type: string (or Expression with resultType string).
 * @property servicePrincipalKey The key of the service principal used to authenticate against the endpoint of a published Azure ML Service pipeline.
 * @property subscriptionId Azure ML Service workspace subscription ID. Type: string (or Expression with resultType string).
 * @property tenant The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string).
 * @property type Type of linked service.
 * Expected value is 'AzureMLService'.
 */
public data class AzureMLServiceLinkedServiceArgs(
    public val annotations: Output<List<Any>>? = null,
    public val authentication: Output<Any>? = null,
    public val connectVia: Output<IntegrationRuntimeReferenceArgs>? = null,
    public val description: Output<String>? = null,
    public val encryptedCredential: Output<String>? = null,
    public val mlWorkspaceName: Output<Any>,
    public val parameters: Output<Map<String, ParameterSpecificationArgs>>? = null,
    public val resourceGroupName: Output<Any>,
    public val servicePrincipalId: Output<Any>? = null,
    public val servicePrincipalKey:
    Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null,
    public val subscriptionId: Output<Any>,
    public val tenant: Output<Any>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.AzureMLServiceLinkedServiceArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.AzureMLServiceLinkedServiceArgs =
        com.pulumi.azurenative.datafactory.inputs.AzureMLServiceLinkedServiceArgs.builder()
            .annotations(annotations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .authentication(authentication?.applyValue({ args0 -> args0 }))
            .connectVia(connectVia?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .encryptedCredential(encryptedCredential?.applyValue({ args0 -> args0 }))
            .mlWorkspaceName(mlWorkspaceName.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .resourceGroupName(resourceGroupName.applyValue({ args0 -> args0 }))
            .servicePrincipalId(servicePrincipalId?.applyValue({ args0 -> args0 }))
            .servicePrincipalKey(
                servicePrincipalKey?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .subscriptionId(subscriptionId.applyValue({ args0 -> args0 }))
            .tenant(tenant?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureMLServiceLinkedServiceArgs].
 */
@PulumiTagMarker
public class AzureMLServiceLinkedServiceArgsBuilder internal constructor() {
    private var annotations: Output<List<Any>>? = null

    private var authentication: Output<Any>? = null

    private var connectVia: Output<IntegrationRuntimeReferenceArgs>? = null

    private var description: Output<String>? = null

    private var encryptedCredential: Output<String>? = null

    private var mlWorkspaceName: Output<Any>? = null

    private var parameters: Output<Map<String, ParameterSpecificationArgs>>? = null

    private var resourceGroupName: Output<Any>? = null

    private var servicePrincipalId: Output<Any>? = null

    private var servicePrincipalKey:
        Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null

    private var subscriptionId: Output<Any>? = null

    private var tenant: Output<Any>? = null

    private var type: Output<String>? = null

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("bnjpsajppespegeh")
    public suspend fun annotations(`value`: Output<List<Any>>) {
        this.annotations = value
    }

    @JvmName("lkmbojdjqxeqigpo")
    public suspend fun annotations(vararg values: Output<Any>) {
        this.annotations = Output.all(values.asList())
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("ixrxdcmjyufjekwv")
    public suspend fun annotations(values: List<Output<Any>>) {
        this.annotations = Output.all(values)
    }

    /**
     * @param value Type of authentication (Required to specify MSI) used to connect to AzureML. Type: string (or Expression with resultType string).
     */
    @JvmName("bvtojiehmqpogcoj")
    public suspend fun authentication(`value`: Output<Any>) {
        this.authentication = value
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("ovhnpsbhhpkgopgk")
    public suspend fun connectVia(`value`: Output<IntegrationRuntimeReferenceArgs>) {
        this.connectVia = value
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("rbrsplorowlubkqn")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("cdpvxlvgpwjlnikr")
    public suspend fun encryptedCredential(`value`: Output<String>) {
        this.encryptedCredential = value
    }

    /**
     * @param value Azure ML Service workspace name. Type: string (or Expression with resultType string).
     */
    @JvmName("pwjmmuhbmebmwpgv")
    public suspend fun mlWorkspaceName(`value`: Output<Any>) {
        this.mlWorkspaceName = value
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("ewrydrkqouioutut")
    public suspend fun parameters(`value`: Output<Map<String, ParameterSpecificationArgs>>) {
        this.parameters = value
    }

    /**
     * @param value Azure ML Service workspace resource group name. Type: string (or Expression with resultType string).
     */
    @JvmName("xeavkulovfxilelk")
    public suspend fun resourceGroupName(`value`: Output<Any>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The ID of the service principal used to authenticate against the endpoint of a published Azure ML Service pipeline. Type: string (or Expression with resultType string).
     */
    @JvmName("bqjnkmtwxwhmrswu")
    public suspend fun servicePrincipalId(`value`: Output<Any>) {
        this.servicePrincipalId = value
    }

    /**
     * @param value The key of the service principal used to authenticate against the endpoint of a published Azure ML Service pipeline.
     */
    @JvmName("lokejyafpyaethet")
    public suspend
    fun servicePrincipalKey(`value`: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>) {
        this.servicePrincipalKey = value
    }

    /**
     * @param value Azure ML Service workspace subscription ID. Type: string (or Expression with resultType string).
     */
    @JvmName("fkhrwcqjeigauekx")
    public suspend fun subscriptionId(`value`: Output<Any>) {
        this.subscriptionId = value
    }

    /**
     * @param value The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string).
     */
    @JvmName("qyoobfcbtjvncdxu")
    public suspend fun tenant(`value`: Output<Any>) {
        this.tenant = value
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'AzureMLService'.
     */
    @JvmName("kdssiayhoxgmaupj")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("fpwwgrtugqxfnatx")
    public suspend fun annotations(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("usfiojjxjqognglx")
    public suspend fun annotations(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param value Type of authentication (Required to specify MSI) used to connect to AzureML. Type: string (or Expression with resultType string).
     */
    @JvmName("brmdypkoadnvumdp")
    public suspend fun authentication(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authentication = mapped
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("eupmjmhbtqmqyicx")
    public suspend fun connectVia(`value`: IntegrationRuntimeReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectVia = mapped
    }

    /**
     * @param argument The integration runtime reference.
     */
    @JvmName("btjydthylllgjqfq")
    public suspend
    fun connectVia(argument: suspend IntegrationRuntimeReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = IntegrationRuntimeReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.connectVia = mapped
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("atxwjycjsgjlkkhd")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("qvvcpghdjpwyoifb")
    public suspend fun encryptedCredential(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptedCredential = mapped
    }

    /**
     * @param value Azure ML Service workspace name. Type: string (or Expression with resultType string).
     */
    @JvmName("ccixxhmostesmyka")
    public suspend fun mlWorkspaceName(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mlWorkspaceName = mapped
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("ecscsqyjittfwoau")
    public suspend fun parameters(`value`: Map<String, ParameterSpecificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Parameters for linked service.
     */
    @JvmName("tdwqxxsxossotlrh")
    public suspend fun parameters(
        vararg
        argument: Pair<String, suspend ParameterSpecificationArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ParameterSpecificationArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Parameters for linked service.
     */
    @JvmName("marfwuoosetjnvmu")
    public fun parameters(vararg values: Pair<String, ParameterSpecificationArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value Azure ML Service workspace resource group name. Type: string (or Expression with resultType string).
     */
    @JvmName("xmexpjedeksmhooq")
    public suspend fun resourceGroupName(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The ID of the service principal used to authenticate against the endpoint of a published Azure ML Service pipeline. Type: string (or Expression with resultType string).
     */
    @JvmName("myljrrbwpiihjjyc")
    public suspend fun servicePrincipalId(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.servicePrincipalId = mapped
    }

    /**
     * @param value The key of the service principal used to authenticate against the endpoint of a published Azure ML Service pipeline.
     */
    @JvmName("ybfihagjqyvmpawe")
    public suspend
    fun servicePrincipalKey(`value`: Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.servicePrincipalKey = mapped
    }

    /**
     * @param value The key of the service principal used to authenticate against the endpoint of a published Azure ML Service pipeline.
     */
    @JvmName("siqogrnjejycoayg")
    public fun servicePrincipalKey(`value`: AzureKeyVaultSecretReferenceArgs) {
        val toBeMapped = Either.ofLeft<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.servicePrincipalKey = mapped
    }

    /**
     * @param value The key of the service principal used to authenticate against the endpoint of a published Azure ML Service pipeline.
     */
    @JvmName("njvuqtdkhuakashm")
    public fun servicePrincipalKey(`value`: SecureStringArgs) {
        val toBeMapped = Either.ofRight<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.servicePrincipalKey = mapped
    }

    /**
     * @param value Azure ML Service workspace subscription ID. Type: string (or Expression with resultType string).
     */
    @JvmName("wgskfqyukwkceayg")
    public suspend fun subscriptionId(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subscriptionId = mapped
    }

    /**
     * @param value The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string).
     */
    @JvmName("kxearnwtykdjuupq")
    public suspend fun tenant(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tenant = mapped
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'AzureMLService'.
     */
    @JvmName("tnaoyskjwhsiqetl")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): AzureMLServiceLinkedServiceArgs = AzureMLServiceLinkedServiceArgs(
        annotations = annotations,
        authentication = authentication,
        connectVia = connectVia,
        description = description,
        encryptedCredential = encryptedCredential,
        mlWorkspaceName = mlWorkspaceName ?: throw PulumiNullFieldException("mlWorkspaceName"),
        parameters = parameters,
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        servicePrincipalId = servicePrincipalId,
        servicePrincipalKey = servicePrincipalKey,
        subscriptionId = subscriptionId ?: throw PulumiNullFieldException("subscriptionId"),
        tenant = tenant,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
