@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.CustomActivityReferenceObjectArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Reference objects for custom activity
 * @property datasets Dataset references.
 * @property linkedServices Linked service references.
 */
public data class CustomActivityReferenceObjectArgs(
    public val datasets: Output<List<DatasetReferenceArgs>>? = null,
    public val linkedServices: Output<List<LinkedServiceReferenceArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.CustomActivityReferenceObjectArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.CustomActivityReferenceObjectArgs =
        com.pulumi.azurenative.datafactory.inputs.CustomActivityReferenceObjectArgs.builder()
            .datasets(
                datasets?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .linkedServices(
                linkedServices?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [CustomActivityReferenceObjectArgs].
 */
@PulumiTagMarker
public class CustomActivityReferenceObjectArgsBuilder internal constructor() {
    private var datasets: Output<List<DatasetReferenceArgs>>? = null

    private var linkedServices: Output<List<LinkedServiceReferenceArgs>>? = null

    /**
     * @param value Dataset references.
     */
    @JvmName("dlpbwanhojytvbrk")
    public suspend fun datasets(`value`: Output<List<DatasetReferenceArgs>>) {
        this.datasets = value
    }

    @JvmName("kwdrpjmaikdskaie")
    public suspend fun datasets(vararg values: Output<DatasetReferenceArgs>) {
        this.datasets = Output.all(values.asList())
    }

    /**
     * @param values Dataset references.
     */
    @JvmName("bkcwlnavvcqqwcwg")
    public suspend fun datasets(values: List<Output<DatasetReferenceArgs>>) {
        this.datasets = Output.all(values)
    }

    /**
     * @param value Linked service references.
     */
    @JvmName("hhrxjrvrilbghoyb")
    public suspend fun linkedServices(`value`: Output<List<LinkedServiceReferenceArgs>>) {
        this.linkedServices = value
    }

    @JvmName("meklffwkbjjclxbl")
    public suspend fun linkedServices(vararg values: Output<LinkedServiceReferenceArgs>) {
        this.linkedServices = Output.all(values.asList())
    }

    /**
     * @param values Linked service references.
     */
    @JvmName("rtfywbdhaoumbutq")
    public suspend fun linkedServices(values: List<Output<LinkedServiceReferenceArgs>>) {
        this.linkedServices = Output.all(values)
    }

    /**
     * @param value Dataset references.
     */
    @JvmName("dqubsnxleduajfuo")
    public suspend fun datasets(`value`: List<DatasetReferenceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.datasets = mapped
    }

    /**
     * @param argument Dataset references.
     */
    @JvmName("undcspogkktuhoyv")
    public suspend fun datasets(argument: List<suspend DatasetReferenceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DatasetReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.datasets = mapped
    }

    /**
     * @param argument Dataset references.
     */
    @JvmName("tryrsacwubdgwekw")
    public suspend fun datasets(vararg argument: suspend DatasetReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DatasetReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.datasets = mapped
    }

    /**
     * @param argument Dataset references.
     */
    @JvmName("wfdlekabswbpomjt")
    public suspend fun datasets(argument: suspend DatasetReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(DatasetReferenceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.datasets = mapped
    }

    /**
     * @param values Dataset references.
     */
    @JvmName("btqgwwvwocuqkups")
    public suspend fun datasets(vararg values: DatasetReferenceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.datasets = mapped
    }

    /**
     * @param value Linked service references.
     */
    @JvmName("vuaqdsggiicpxksu")
    public suspend fun linkedServices(`value`: List<LinkedServiceReferenceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linkedServices = mapped
    }

    /**
     * @param argument Linked service references.
     */
    @JvmName("ckifahftbcedtoea")
    public suspend
    fun linkedServices(argument: List<suspend LinkedServiceReferenceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            LinkedServiceReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.linkedServices = mapped
    }

    /**
     * @param argument Linked service references.
     */
    @JvmName("qffbhujvqrjgcwyu")
    public suspend fun linkedServices(
        vararg
        argument: suspend LinkedServiceReferenceArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            LinkedServiceReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.linkedServices = mapped
    }

    /**
     * @param argument Linked service references.
     */
    @JvmName("nsmrlntmvnkpuykj")
    public suspend
    fun linkedServices(argument: suspend LinkedServiceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(LinkedServiceReferenceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.linkedServices = mapped
    }

    /**
     * @param values Linked service references.
     */
    @JvmName("cecnffhnbnjgofok")
    public suspend fun linkedServices(vararg values: LinkedServiceReferenceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.linkedServices = mapped
    }

    internal fun build(): CustomActivityReferenceObjectArgs = CustomActivityReferenceObjectArgs(
        datasets = datasets,
        linkedServices = linkedServices,
    )
}
