@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.CustomEventsTriggerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Trigger that runs every time a custom event is received.
 * @property annotations List of tags that can be used for describing the trigger.
 * @property description Trigger description.
 * @property events The list of event types that cause this trigger to fire.
 * @property pipelines Pipelines that need to be started.
 * @property scope The ARM resource ID of the Azure Event Grid Topic.
 * @property subjectBeginsWith The event subject must begin with the pattern provided for trigger to fire. At least one of these must be provided: subjectBeginsWith, subjectEndsWith.
 * @property subjectEndsWith The event subject must end with the pattern provided for trigger to fire. At least one of these must be provided: subjectBeginsWith, subjectEndsWith.
 * @property type Trigger type.
 * Expected value is 'CustomEventsTrigger'.
 */
public data class CustomEventsTriggerArgs(
    public val annotations: Output<List<Any>>? = null,
    public val description: Output<String>? = null,
    public val events: Output<List<Any>>,
    public val pipelines: Output<List<TriggerPipelineReferenceArgs>>? = null,
    public val scope: Output<String>,
    public val subjectBeginsWith: Output<String>? = null,
    public val subjectEndsWith: Output<String>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.CustomEventsTriggerArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.CustomEventsTriggerArgs =
        com.pulumi.azurenative.datafactory.inputs.CustomEventsTriggerArgs.builder()
            .annotations(annotations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .events(events.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .pipelines(
                pipelines?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .scope(scope.applyValue({ args0 -> args0 }))
            .subjectBeginsWith(subjectBeginsWith?.applyValue({ args0 -> args0 }))
            .subjectEndsWith(subjectEndsWith?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CustomEventsTriggerArgs].
 */
@PulumiTagMarker
public class CustomEventsTriggerArgsBuilder internal constructor() {
    private var annotations: Output<List<Any>>? = null

    private var description: Output<String>? = null

    private var events: Output<List<Any>>? = null

    private var pipelines: Output<List<TriggerPipelineReferenceArgs>>? = null

    private var scope: Output<String>? = null

    private var subjectBeginsWith: Output<String>? = null

    private var subjectEndsWith: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value List of tags that can be used for describing the trigger.
     */
    @JvmName("svkwrrrwdwdclchj")
    public suspend fun annotations(`value`: Output<List<Any>>) {
        this.annotations = value
    }

    @JvmName("khslxbxkurffpsfq")
    public suspend fun annotations(vararg values: Output<Any>) {
        this.annotations = Output.all(values.asList())
    }

    /**
     * @param values List of tags that can be used for describing the trigger.
     */
    @JvmName("refuoexsxkoxelgl")
    public suspend fun annotations(values: List<Output<Any>>) {
        this.annotations = Output.all(values)
    }

    /**
     * @param value Trigger description.
     */
    @JvmName("yrvlgympiucngiqf")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The list of event types that cause this trigger to fire.
     */
    @JvmName("kfbrwoifbixsjovd")
    public suspend fun events(`value`: Output<List<Any>>) {
        this.events = value
    }

    @JvmName("ibyxkdtpcurymgew")
    public suspend fun events(vararg values: Output<Any>) {
        this.events = Output.all(values.asList())
    }

    /**
     * @param values The list of event types that cause this trigger to fire.
     */
    @JvmName("muianjcrnxclfhku")
    public suspend fun events(values: List<Output<Any>>) {
        this.events = Output.all(values)
    }

    /**
     * @param value Pipelines that need to be started.
     */
    @JvmName("pvfcvtuncciwhbbe")
    public suspend fun pipelines(`value`: Output<List<TriggerPipelineReferenceArgs>>) {
        this.pipelines = value
    }

    @JvmName("mlwowhlfqlbjekev")
    public suspend fun pipelines(vararg values: Output<TriggerPipelineReferenceArgs>) {
        this.pipelines = Output.all(values.asList())
    }

    /**
     * @param values Pipelines that need to be started.
     */
    @JvmName("xifvqyhiiqpbvujt")
    public suspend fun pipelines(values: List<Output<TriggerPipelineReferenceArgs>>) {
        this.pipelines = Output.all(values)
    }

    /**
     * @param value The ARM resource ID of the Azure Event Grid Topic.
     */
    @JvmName("xxwmckugthcrhbuf")
    public suspend fun scope(`value`: Output<String>) {
        this.scope = value
    }

    /**
     * @param value The event subject must begin with the pattern provided for trigger to fire. At least one of these must be provided: subjectBeginsWith, subjectEndsWith.
     */
    @JvmName("fdmqstbajpdgnoyf")
    public suspend fun subjectBeginsWith(`value`: Output<String>) {
        this.subjectBeginsWith = value
    }

    /**
     * @param value The event subject must end with the pattern provided for trigger to fire. At least one of these must be provided: subjectBeginsWith, subjectEndsWith.
     */
    @JvmName("pmmxxqyusypasjar")
    public suspend fun subjectEndsWith(`value`: Output<String>) {
        this.subjectEndsWith = value
    }

    /**
     * @param value Trigger type.
     * Expected value is 'CustomEventsTrigger'.
     */
    @JvmName("aftpxtmvuaujtumf")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value List of tags that can be used for describing the trigger.
     */
    @JvmName("yuigawhdbuefaufm")
    public suspend fun annotations(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param values List of tags that can be used for describing the trigger.
     */
    @JvmName("dfukjxcqvdiptgpy")
    public suspend fun annotations(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param value Trigger description.
     */
    @JvmName("kkveuxrwlyoeasft")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The list of event types that cause this trigger to fire.
     */
    @JvmName("lkqlfekxjjaxpppb")
    public suspend fun events(`value`: List<Any>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.events = mapped
    }

    /**
     * @param values The list of event types that cause this trigger to fire.
     */
    @JvmName("svidnlmwtjygyweh")
    public suspend fun events(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.events = mapped
    }

    /**
     * @param value Pipelines that need to be started.
     */
    @JvmName("miexmhxnqtesxfar")
    public suspend fun pipelines(`value`: List<TriggerPipelineReferenceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pipelines = mapped
    }

    /**
     * @param argument Pipelines that need to be started.
     */
    @JvmName("vjjjnqncdljwxfig")
    public suspend
    fun pipelines(argument: List<suspend TriggerPipelineReferenceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TriggerPipelineReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.pipelines = mapped
    }

    /**
     * @param argument Pipelines that need to be started.
     */
    @JvmName("mlmlobynorxcayjc")
    public suspend fun pipelines(
        vararg
        argument: suspend TriggerPipelineReferenceArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            TriggerPipelineReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.pipelines = mapped
    }

    /**
     * @param argument Pipelines that need to be started.
     */
    @JvmName("jomnmyyvesdlcugo")
    public suspend fun pipelines(argument: suspend TriggerPipelineReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            TriggerPipelineReferenceArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.pipelines = mapped
    }

    /**
     * @param values Pipelines that need to be started.
     */
    @JvmName("agttfyadbnnvtnrb")
    public suspend fun pipelines(vararg values: TriggerPipelineReferenceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.pipelines = mapped
    }

    /**
     * @param value The ARM resource ID of the Azure Event Grid Topic.
     */
    @JvmName("yjolecnajgpegrlp")
    public suspend fun scope(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    /**
     * @param value The event subject must begin with the pattern provided for trigger to fire. At least one of these must be provided: subjectBeginsWith, subjectEndsWith.
     */
    @JvmName("nefobumcqedjibqa")
    public suspend fun subjectBeginsWith(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subjectBeginsWith = mapped
    }

    /**
     * @param value The event subject must end with the pattern provided for trigger to fire. At least one of these must be provided: subjectBeginsWith, subjectEndsWith.
     */
    @JvmName("ycycgrklksxnxcum")
    public suspend fun subjectEndsWith(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subjectEndsWith = mapped
    }

    /**
     * @param value Trigger type.
     * Expected value is 'CustomEventsTrigger'.
     */
    @JvmName("tuvygmbwyjesjhhb")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): CustomEventsTriggerArgs = CustomEventsTriggerArgs(
        annotations = annotations,
        description = description,
        events = events ?: throw PulumiNullFieldException("events"),
        pipelines = pipelines,
        scope = scope ?: throw PulumiNullFieldException("scope"),
        subjectBeginsWith = subjectBeginsWith,
        subjectEndsWith = subjectEndsWith,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
