@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.DataFlowFolderArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The folder that this data flow is in. If not specified, Data flow will appear at the root level.
 * @property name The name of the folder that this data flow is in.
 */
public data class DataFlowFolderArgs(
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.DataFlowFolderArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.DataFlowFolderArgs =
        com.pulumi.azurenative.datafactory.inputs.DataFlowFolderArgs.builder()
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataFlowFolderArgs].
 */
@PulumiTagMarker
public class DataFlowFolderArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    /**
     * @param value The name of the folder that this data flow is in.
     */
    @JvmName("aygrubkhjxbbvwlb")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the folder that this data flow is in.
     */
    @JvmName("xfjyyvwboxefdbqo")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): DataFlowFolderArgs = DataFlowFolderArgs(
        name = name,
    )
}
