@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.DataFlowReferenceArgs.builder
import com.pulumi.azurenative.datafactory.kotlin.enums.DataFlowReferenceType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Data flow reference type.
 * @property datasetParameters Reference data flow parameters from dataset.
 * @property parameters Data flow parameters
 * @property referenceName Reference data flow name.
 * @property type Data flow reference type.
 */
public data class DataFlowReferenceArgs(
    public val datasetParameters: Output<Any>? = null,
    public val parameters: Output<Map<String, Any>>? = null,
    public val referenceName: Output<String>,
    public val type: Output<Either<String, DataFlowReferenceType>>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.DataFlowReferenceArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.DataFlowReferenceArgs =
        com.pulumi.azurenative.datafactory.inputs.DataFlowReferenceArgs.builder()
            .datasetParameters(datasetParameters?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .referenceName(referenceName.applyValue({ args0 -> args0 }))
            .type(
                type.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [DataFlowReferenceArgs].
 */
@PulumiTagMarker
public class DataFlowReferenceArgsBuilder internal constructor() {
    private var datasetParameters: Output<Any>? = null

    private var parameters: Output<Map<String, Any>>? = null

    private var referenceName: Output<String>? = null

    private var type: Output<Either<String, DataFlowReferenceType>>? = null

    /**
     * @param value Reference data flow parameters from dataset.
     */
    @JvmName("cvmtaglbasoluxit")
    public suspend fun datasetParameters(`value`: Output<Any>) {
        this.datasetParameters = value
    }

    /**
     * @param value Data flow parameters
     */
    @JvmName("ctxtgjltfvqxuapb")
    public suspend fun parameters(`value`: Output<Map<String, Any>>) {
        this.parameters = value
    }

    /**
     * @param value Reference data flow name.
     */
    @JvmName("nusiwuhmrhukiupt")
    public suspend fun referenceName(`value`: Output<String>) {
        this.referenceName = value
    }

    /**
     * @param value Data flow reference type.
     */
    @JvmName("kshqscnsecexisdi")
    public suspend fun type(`value`: Output<Either<String, DataFlowReferenceType>>) {
        this.type = value
    }

    /**
     * @param value Reference data flow parameters from dataset.
     */
    @JvmName("xvdjndhekhpfkegt")
    public suspend fun datasetParameters(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.datasetParameters = mapped
    }

    /**
     * @param value Data flow parameters
     */
    @JvmName("fpfndohtxeuoawqb")
    public suspend fun parameters(`value`: Map<String, Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param values Data flow parameters
     */
    @JvmName("lnfpuqhwajhdfbjk")
    public fun parameters(vararg values: Pair<String, Any>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value Reference data flow name.
     */
    @JvmName("fvaicdtidkvfvmyh")
    public suspend fun referenceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.referenceName = mapped
    }

    /**
     * @param value Data flow reference type.
     */
    @JvmName("ghoxydustdlhwyqh")
    public suspend fun type(`value`: Either<String, DataFlowReferenceType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Data flow reference type.
     */
    @JvmName("lwdimcoltxfcksvs")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DataFlowReferenceType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Data flow reference type.
     */
    @JvmName("gdtaectybysvwmsp")
    public fun type(`value`: DataFlowReferenceType) {
        val toBeMapped = Either.ofRight<String, DataFlowReferenceType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): DataFlowReferenceArgs = DataFlowReferenceArgs(
        datasetParameters = datasetParameters,
        parameters = parameters,
        referenceName = referenceName ?: throw PulumiNullFieldException("referenceName"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
