@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.DataFlowSourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Transformation for data flow source.
 * @property dataset Dataset reference.
 * @property description Transformation description.
 * @property flowlet Flowlet Reference
 * @property linkedService Linked service reference.
 * @property name Transformation name.
 * @property schemaLinkedService Schema linked service reference.
 */
public data class DataFlowSourceArgs(
    public val dataset: Output<DatasetReferenceArgs>? = null,
    public val description: Output<String>? = null,
    public val flowlet: Output<DataFlowReferenceArgs>? = null,
    public val linkedService: Output<LinkedServiceReferenceArgs>? = null,
    public val name: Output<String>,
    public val schemaLinkedService: Output<LinkedServiceReferenceArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.DataFlowSourceArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.DataFlowSourceArgs =
        com.pulumi.azurenative.datafactory.inputs.DataFlowSourceArgs.builder()
            .dataset(dataset?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .flowlet(flowlet?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .linkedService(linkedService?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name.applyValue({ args0 -> args0 }))
            .schemaLinkedService(
                schemaLinkedService?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [DataFlowSourceArgs].
 */
@PulumiTagMarker
public class DataFlowSourceArgsBuilder internal constructor() {
    private var dataset: Output<DatasetReferenceArgs>? = null

    private var description: Output<String>? = null

    private var flowlet: Output<DataFlowReferenceArgs>? = null

    private var linkedService: Output<LinkedServiceReferenceArgs>? = null

    private var name: Output<String>? = null

    private var schemaLinkedService: Output<LinkedServiceReferenceArgs>? = null

    /**
     * @param value Dataset reference.
     */
    @JvmName("ogkxqsbfbpvdmwsn")
    public suspend fun dataset(`value`: Output<DatasetReferenceArgs>) {
        this.dataset = value
    }

    /**
     * @param value Transformation description.
     */
    @JvmName("rdhdolcxwychmfyu")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Flowlet Reference
     */
    @JvmName("keovkyrjbwnhsfol")
    public suspend fun flowlet(`value`: Output<DataFlowReferenceArgs>) {
        this.flowlet = value
    }

    /**
     * @param value Linked service reference.
     */
    @JvmName("gxlsbvcaysqbcdwe")
    public suspend fun linkedService(`value`: Output<LinkedServiceReferenceArgs>) {
        this.linkedService = value
    }

    /**
     * @param value Transformation name.
     */
    @JvmName("fuydkupgyelybtpm")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Schema linked service reference.
     */
    @JvmName("wfnddumondsojqsy")
    public suspend fun schemaLinkedService(`value`: Output<LinkedServiceReferenceArgs>) {
        this.schemaLinkedService = value
    }

    /**
     * @param value Dataset reference.
     */
    @JvmName("apfhlfpqhablhaeq")
    public suspend fun dataset(`value`: DatasetReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataset = mapped
    }

    /**
     * @param argument Dataset reference.
     */
    @JvmName("wvlnamrxpdkejpoe")
    public suspend fun dataset(argument: suspend DatasetReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = DatasetReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.dataset = mapped
    }

    /**
     * @param value Transformation description.
     */
    @JvmName("lfrrgvumnfjxfjds")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Flowlet Reference
     */
    @JvmName("edrbxhkypquvesar")
    public suspend fun flowlet(`value`: DataFlowReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.flowlet = mapped
    }

    /**
     * @param argument Flowlet Reference
     */
    @JvmName("erynyfbarnxmoayb")
    public suspend fun flowlet(argument: suspend DataFlowReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = DataFlowReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.flowlet = mapped
    }

    /**
     * @param value Linked service reference.
     */
    @JvmName("ldkieabsvrpncgww")
    public suspend fun linkedService(`value`: LinkedServiceReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linkedService = mapped
    }

    /**
     * @param argument Linked service reference.
     */
    @JvmName("qikxjaurenrbtjmw")
    public suspend fun linkedService(argument: suspend LinkedServiceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = LinkedServiceReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.linkedService = mapped
    }

    /**
     * @param value Transformation name.
     */
    @JvmName("obfwunxqiwxhdahb")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Schema linked service reference.
     */
    @JvmName("nbphvpoygnovjppu")
    public suspend fun schemaLinkedService(`value`: LinkedServiceReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schemaLinkedService = mapped
    }

    /**
     * @param argument Schema linked service reference.
     */
    @JvmName("rokmfmobuntrhuge")
    public suspend
    fun schemaLinkedService(argument: suspend LinkedServiceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = LinkedServiceReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.schemaLinkedService = mapped
    }

    internal fun build(): DataFlowSourceArgs = DataFlowSourceArgs(
        dataset = dataset,
        description = description,
        flowlet = flowlet,
        linkedService = linkedService,
        name = name ?: throw PulumiNullFieldException("name"),
        schemaLinkedService = schemaLinkedService,
    )
}
