@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.DataMapperMappingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Source and target table mapping details.
 * @property attributeMappingInfo This holds the user provided attribute mapping information.
 * @property sourceConnectionReference The connection reference for the source connection.
 * @property sourceDenormalizeInfo This holds the source denormalization information used while joining multiple sources.
 * @property sourceEntityName Name of the source table
 * @property targetEntityName Name of the target table
 */
public data class DataMapperMappingArgs(
    public val attributeMappingInfo: Output<MapperAttributeMappingsArgs>? = null,
    public val sourceConnectionReference: Output<MapperConnectionReferenceArgs>? = null,
    public val sourceDenormalizeInfo: Output<Any>? = null,
    public val sourceEntityName: Output<String>? = null,
    public val targetEntityName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.DataMapperMappingArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.DataMapperMappingArgs =
        com.pulumi.azurenative.datafactory.inputs.DataMapperMappingArgs.builder()
            .attributeMappingInfo(
                attributeMappingInfo?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .sourceConnectionReference(
                sourceConnectionReference?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .sourceDenormalizeInfo(sourceDenormalizeInfo?.applyValue({ args0 -> args0 }))
            .sourceEntityName(sourceEntityName?.applyValue({ args0 -> args0 }))
            .targetEntityName(targetEntityName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataMapperMappingArgs].
 */
@PulumiTagMarker
public class DataMapperMappingArgsBuilder internal constructor() {
    private var attributeMappingInfo: Output<MapperAttributeMappingsArgs>? = null

    private var sourceConnectionReference: Output<MapperConnectionReferenceArgs>? = null

    private var sourceDenormalizeInfo: Output<Any>? = null

    private var sourceEntityName: Output<String>? = null

    private var targetEntityName: Output<String>? = null

    /**
     * @param value This holds the user provided attribute mapping information.
     */
    @JvmName("vgmhbukicymdgpkq")
    public suspend fun attributeMappingInfo(`value`: Output<MapperAttributeMappingsArgs>) {
        this.attributeMappingInfo = value
    }

    /**
     * @param value The connection reference for the source connection.
     */
    @JvmName("piouwbwemyhmgpkf")
    public suspend fun sourceConnectionReference(`value`: Output<MapperConnectionReferenceArgs>) {
        this.sourceConnectionReference = value
    }

    /**
     * @param value This holds the source denormalization information used while joining multiple sources.
     */
    @JvmName("nxuymyeaeiunatsy")
    public suspend fun sourceDenormalizeInfo(`value`: Output<Any>) {
        this.sourceDenormalizeInfo = value
    }

    /**
     * @param value Name of the source table
     */
    @JvmName("wuscadelpxyxakal")
    public suspend fun sourceEntityName(`value`: Output<String>) {
        this.sourceEntityName = value
    }

    /**
     * @param value Name of the target table
     */
    @JvmName("kjiqdtgemftvodwr")
    public suspend fun targetEntityName(`value`: Output<String>) {
        this.targetEntityName = value
    }

    /**
     * @param value This holds the user provided attribute mapping information.
     */
    @JvmName("vsmfcehcbikdvnef")
    public suspend fun attributeMappingInfo(`value`: MapperAttributeMappingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.attributeMappingInfo = mapped
    }

    /**
     * @param argument This holds the user provided attribute mapping information.
     */
    @JvmName("oycyrvbluclvfaas")
    public suspend
    fun attributeMappingInfo(argument: suspend MapperAttributeMappingsArgsBuilder.() -> Unit) {
        val toBeMapped = MapperAttributeMappingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.attributeMappingInfo = mapped
    }

    /**
     * @param value The connection reference for the source connection.
     */
    @JvmName("mqdqypciurvfnmdt")
    public suspend fun sourceConnectionReference(`value`: MapperConnectionReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceConnectionReference = mapped
    }

    /**
     * @param argument The connection reference for the source connection.
     */
    @JvmName("cafayhigvdnyspgr")
    public suspend
    fun sourceConnectionReference(argument: suspend MapperConnectionReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = MapperConnectionReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sourceConnectionReference = mapped
    }

    /**
     * @param value This holds the source denormalization information used while joining multiple sources.
     */
    @JvmName("ikxmtxvhuyoevuus")
    public suspend fun sourceDenormalizeInfo(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceDenormalizeInfo = mapped
    }

    /**
     * @param value Name of the source table
     */
    @JvmName("gtpnssplkfnmpvcr")
    public suspend fun sourceEntityName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceEntityName = mapped
    }

    /**
     * @param value Name of the target table
     */
    @JvmName("ahjvylomvjfjuspl")
    public suspend fun targetEntityName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetEntityName = mapped
    }

    internal fun build(): DataMapperMappingArgs = DataMapperMappingArgs(
        attributeMappingInfo = attributeMappingInfo,
        sourceConnectionReference = sourceConnectionReference,
        sourceDenormalizeInfo = sourceDenormalizeInfo,
        sourceEntityName = sourceEntityName,
        targetEntityName = targetEntityName,
    )
}
