@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.DatasetCompressionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The compression method used on a dataset.
 * @property level The dataset compression level. Type: string (or Expression with resultType string).
 * @property type Type of dataset compression. Type: string (or Expression with resultType string).
 */
public data class DatasetCompressionArgs(
    public val level: Output<Any>? = null,
    public val type: Output<Any>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.DatasetCompressionArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.DatasetCompressionArgs =
        com.pulumi.azurenative.datafactory.inputs.DatasetCompressionArgs.builder()
            .level(level?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DatasetCompressionArgs].
 */
@PulumiTagMarker
public class DatasetCompressionArgsBuilder internal constructor() {
    private var level: Output<Any>? = null

    private var type: Output<Any>? = null

    /**
     * @param value The dataset compression level. Type: string (or Expression with resultType string).
     */
    @JvmName("tpksvwelnsggvxlw")
    public suspend fun level(`value`: Output<Any>) {
        this.level = value
    }

    /**
     * @param value Type of dataset compression. Type: string (or Expression with resultType string).
     */
    @JvmName("gtfndkcjfksbsqoe")
    public suspend fun type(`value`: Output<Any>) {
        this.type = value
    }

    /**
     * @param value The dataset compression level. Type: string (or Expression with resultType string).
     */
    @JvmName("pxkfsrcwejutvdcd")
    public suspend fun level(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.level = mapped
    }

    /**
     * @param value Type of dataset compression. Type: string (or Expression with resultType string).
     */
    @JvmName("veujaypqfweqmxar")
    public suspend fun type(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): DatasetCompressionArgs = DatasetCompressionArgs(
        level = level,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
