@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.DelimitedTextReadSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Delimited text read settings.
 * @property compressionProperties Compression settings.
 * @property skipLineCount Indicates the number of non-empty rows to skip when reading data from input files. Type: integer (or Expression with resultType integer).
 * @property type The read setting type.
 * Expected value is 'DelimitedTextReadSettings'.
 */
public data class DelimitedTextReadSettingsArgs(
    public val compressionProperties: Output<Any>? = null,
    public val skipLineCount: Output<Any>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.DelimitedTextReadSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.DelimitedTextReadSettingsArgs =
        com.pulumi.azurenative.datafactory.inputs.DelimitedTextReadSettingsArgs.builder()
            .compressionProperties(compressionProperties?.applyValue({ args0 -> args0 }))
            .skipLineCount(skipLineCount?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DelimitedTextReadSettingsArgs].
 */
@PulumiTagMarker
public class DelimitedTextReadSettingsArgsBuilder internal constructor() {
    private var compressionProperties: Output<Any>? = null

    private var skipLineCount: Output<Any>? = null

    private var type: Output<String>? = null

    /**
     * @param value Compression settings.
     */
    @JvmName("xrirmqdylswyrrnd")
    public suspend fun compressionProperties(`value`: Output<Any>) {
        this.compressionProperties = value
    }

    /**
     * @param value Indicates the number of non-empty rows to skip when reading data from input files. Type: integer (or Expression with resultType integer).
     */
    @JvmName("nosrfthjsgmgeqql")
    public suspend fun skipLineCount(`value`: Output<Any>) {
        this.skipLineCount = value
    }

    /**
     * @param value The read setting type.
     * Expected value is 'DelimitedTextReadSettings'.
     */
    @JvmName("xaenmivqhgvnpcpd")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Compression settings.
     */
    @JvmName("vhpiosohasopnqtt")
    public suspend fun compressionProperties(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.compressionProperties = mapped
    }

    /**
     * @param value Indicates the number of non-empty rows to skip when reading data from input files. Type: integer (or Expression with resultType integer).
     */
    @JvmName("viguinnpyaikyksx")
    public suspend fun skipLineCount(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.skipLineCount = mapped
    }

    /**
     * @param value The read setting type.
     * Expected value is 'DelimitedTextReadSettings'.
     */
    @JvmName("aolxravmnjgrnbxr")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): DelimitedTextReadSettingsArgs = DelimitedTextReadSettingsArgs(
        compressionProperties = compressionProperties,
        skipLineCount = skipLineCount,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
