@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.DistcpSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Distcp settings.
 * @property distcpOptions Specifies the Distcp options. Type: string (or Expression with resultType string).
 * @property resourceManagerEndpoint Specifies the Yarn ResourceManager endpoint. Type: string (or Expression with resultType string).
 * @property tempScriptPath Specifies an existing folder path which will be used to store temp Distcp command script. The script file is generated by ADF and will be removed after Copy job finished. Type: string (or Expression with resultType string).
 */
public data class DistcpSettingsArgs(
    public val distcpOptions: Output<Any>? = null,
    public val resourceManagerEndpoint: Output<Any>,
    public val tempScriptPath: Output<Any>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.DistcpSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.DistcpSettingsArgs =
        com.pulumi.azurenative.datafactory.inputs.DistcpSettingsArgs.builder()
            .distcpOptions(distcpOptions?.applyValue({ args0 -> args0 }))
            .resourceManagerEndpoint(resourceManagerEndpoint.applyValue({ args0 -> args0 }))
            .tempScriptPath(tempScriptPath.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DistcpSettingsArgs].
 */
@PulumiTagMarker
public class DistcpSettingsArgsBuilder internal constructor() {
    private var distcpOptions: Output<Any>? = null

    private var resourceManagerEndpoint: Output<Any>? = null

    private var tempScriptPath: Output<Any>? = null

    /**
     * @param value Specifies the Distcp options. Type: string (or Expression with resultType string).
     */
    @JvmName("rdqvifxdtnuefwnq")
    public suspend fun distcpOptions(`value`: Output<Any>) {
        this.distcpOptions = value
    }

    /**
     * @param value Specifies the Yarn ResourceManager endpoint. Type: string (or Expression with resultType string).
     */
    @JvmName("aaeofgrovfjxuidu")
    public suspend fun resourceManagerEndpoint(`value`: Output<Any>) {
        this.resourceManagerEndpoint = value
    }

    /**
     * @param value Specifies an existing folder path which will be used to store temp Distcp command script. The script file is generated by ADF and will be removed after Copy job finished. Type: string (or Expression with resultType string).
     */
    @JvmName("swebhyunikcxqbsc")
    public suspend fun tempScriptPath(`value`: Output<Any>) {
        this.tempScriptPath = value
    }

    /**
     * @param value Specifies the Distcp options. Type: string (or Expression with resultType string).
     */
    @JvmName("vmviemomqkacwhen")
    public suspend fun distcpOptions(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.distcpOptions = mapped
    }

    /**
     * @param value Specifies the Yarn ResourceManager endpoint. Type: string (or Expression with resultType string).
     */
    @JvmName("ddwdlffbdvfkipug")
    public suspend fun resourceManagerEndpoint(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceManagerEndpoint = mapped
    }

    /**
     * @param value Specifies an existing folder path which will be used to store temp Distcp command script. The script file is generated by ADF and will be removed after Copy job finished. Type: string (or Expression with resultType string).
     */
    @JvmName("glehhpytfppiakgl")
    public suspend fun tempScriptPath(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tempScriptPath = mapped
    }

    internal fun build(): DistcpSettingsArgs = DistcpSettingsArgs(
        distcpOptions = distcpOptions,
        resourceManagerEndpoint = resourceManagerEndpoint ?: throw
            PulumiNullFieldException("resourceManagerEndpoint"),
        tempScriptPath = tempScriptPath ?: throw PulumiNullFieldException("tempScriptPath"),
    )
}
