@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.GetFactoryDataPlaneAccessPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accessResourcePath The resource path to get access relative to factory. Currently only empty string is supported which corresponds to the factory resource.
 * @property expireTime Expiration time for the token. Maximum duration for the token is eight hours and by default the token will expire in eight hours.
 * @property factoryName The factory name.
 * @property permissions The string with permissions for Data Plane access. Currently only 'r' is supported which grants read only access.
 * @property profileName The name of the profile. Currently only the default is supported. The default value is DefaultProfile.
 * @property resourceGroupName The resource group name.
 * @property startTime Start time for the token. If not specified the current time will be used.
 */
public data class GetFactoryDataPlaneAccessPlainArgs(
    public val accessResourcePath: String? = null,
    public val expireTime: String? = null,
    public val factoryName: String,
    public val permissions: String? = null,
    public val profileName: String? = null,
    public val resourceGroupName: String,
    public val startTime: String? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.GetFactoryDataPlaneAccessPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.datafactory.inputs.GetFactoryDataPlaneAccessPlainArgs =
        com.pulumi.azurenative.datafactory.inputs.GetFactoryDataPlaneAccessPlainArgs.builder()
            .accessResourcePath(accessResourcePath?.let({ args0 -> args0 }))
            .expireTime(expireTime?.let({ args0 -> args0 }))
            .factoryName(factoryName.let({ args0 -> args0 }))
            .permissions(permissions?.let({ args0 -> args0 }))
            .profileName(profileName?.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .startTime(startTime?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetFactoryDataPlaneAccessPlainArgs].
 */
@PulumiTagMarker
public class GetFactoryDataPlaneAccessPlainArgsBuilder internal constructor() {
    private var accessResourcePath: String? = null

    private var expireTime: String? = null

    private var factoryName: String? = null

    private var permissions: String? = null

    private var profileName: String? = null

    private var resourceGroupName: String? = null

    private var startTime: String? = null

    /**
     * @param value The resource path to get access relative to factory. Currently only empty string is supported which corresponds to the factory resource.
     */
    @JvmName("tjgygfmkpotlnofu")
    public suspend fun accessResourcePath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.accessResourcePath = mapped
    }

    /**
     * @param value Expiration time for the token. Maximum duration for the token is eight hours and by default the token will expire in eight hours.
     */
    @JvmName("oueljtubbeoxpjox")
    public suspend fun expireTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.expireTime = mapped
    }

    /**
     * @param value The factory name.
     */
    @JvmName("ytruodwfoyuieghp")
    public suspend fun factoryName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.factoryName = mapped
    }

    /**
     * @param value The string with permissions for Data Plane access. Currently only 'r' is supported which grants read only access.
     */
    @JvmName("mhldqhcsbqixapmj")
    public suspend fun permissions(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.permissions = mapped
    }

    /**
     * @param value The name of the profile. Currently only the default is supported. The default value is DefaultProfile.
     */
    @JvmName("xxjdcajclsowgykj")
    public suspend fun profileName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.profileName = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("sfcdkmglobglnkee")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Start time for the token. If not specified the current time will be used.
     */
    @JvmName("ldjylpaboubcrkhy")
    public suspend fun startTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.startTime = mapped
    }

    internal fun build(): GetFactoryDataPlaneAccessPlainArgs = GetFactoryDataPlaneAccessPlainArgs(
        accessResourcePath = accessResourcePath,
        expireTime = expireTime,
        factoryName = factoryName ?: throw PulumiNullFieldException("factoryName"),
        permissions = permissions,
        profileName = profileName,
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        startTime = startTime,
    )
}
