@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.GetLinkedServicePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property factoryName The factory name.
 * @property linkedServiceName The linked service name.
 * @property resourceGroupName The resource group name.
 */
public data class GetLinkedServicePlainArgs(
    public val factoryName: String,
    public val linkedServiceName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.GetLinkedServicePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.GetLinkedServicePlainArgs =
        com.pulumi.azurenative.datafactory.inputs.GetLinkedServicePlainArgs.builder()
            .factoryName(factoryName.let({ args0 -> args0 }))
            .linkedServiceName(linkedServiceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetLinkedServicePlainArgs].
 */
@PulumiTagMarker
public class GetLinkedServicePlainArgsBuilder internal constructor() {
    private var factoryName: String? = null

    private var linkedServiceName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The factory name.
     */
    @JvmName("jojknxdoywsycnam")
    public suspend fun factoryName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.factoryName = mapped
    }

    /**
     * @param value The linked service name.
     */
    @JvmName("rxqrqjrfbvjnrgkn")
    public suspend fun linkedServiceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.linkedServiceName = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("oohrisgjrxuanxer")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetLinkedServicePlainArgs = GetLinkedServicePlainArgs(
        factoryName = factoryName ?: throw PulumiNullFieldException("factoryName"),
        linkedServiceName = linkedServiceName ?: throw PulumiNullFieldException("linkedServiceName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
