@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.GetManagedPrivateEndpointPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property factoryName The factory name.
 * @property managedPrivateEndpointName Managed private endpoint name
 * @property managedVirtualNetworkName Managed virtual network name
 * @property resourceGroupName The resource group name.
 */
public data class GetManagedPrivateEndpointPlainArgs(
    public val factoryName: String,
    public val managedPrivateEndpointName: String,
    public val managedVirtualNetworkName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.GetManagedPrivateEndpointPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.datafactory.inputs.GetManagedPrivateEndpointPlainArgs =
        com.pulumi.azurenative.datafactory.inputs.GetManagedPrivateEndpointPlainArgs.builder()
            .factoryName(factoryName.let({ args0 -> args0 }))
            .managedPrivateEndpointName(managedPrivateEndpointName.let({ args0 -> args0 }))
            .managedVirtualNetworkName(managedVirtualNetworkName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetManagedPrivateEndpointPlainArgs].
 */
@PulumiTagMarker
public class GetManagedPrivateEndpointPlainArgsBuilder internal constructor() {
    private var factoryName: String? = null

    private var managedPrivateEndpointName: String? = null

    private var managedVirtualNetworkName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The factory name.
     */
    @JvmName("xpqjgmabldibjrpa")
    public suspend fun factoryName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.factoryName = mapped
    }

    /**
     * @param value Managed private endpoint name
     */
    @JvmName("ujjwmweyqbaxjsje")
    public suspend fun managedPrivateEndpointName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.managedPrivateEndpointName = mapped
    }

    /**
     * @param value Managed virtual network name
     */
    @JvmName("wwgbenangqphfeod")
    public suspend fun managedVirtualNetworkName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.managedVirtualNetworkName = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("yscjugsfsnipfjaq")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetManagedPrivateEndpointPlainArgs = GetManagedPrivateEndpointPlainArgs(
        factoryName = factoryName ?: throw PulumiNullFieldException("factoryName"),
        managedPrivateEndpointName = managedPrivateEndpointName ?: throw
            PulumiNullFieldException("managedPrivateEndpointName"),
        managedVirtualNetworkName = managedVirtualNetworkName ?: throw
            PulumiNullFieldException("managedVirtualNetworkName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
