@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.GetTriggerEventSubscriptionStatusPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property factoryName The factory name.
 * @property resourceGroupName The resource group name.
 * @property triggerName The trigger name.
 */
public data class GetTriggerEventSubscriptionStatusPlainArgs(
    public val factoryName: String,
    public val resourceGroupName: String,
    public val triggerName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.GetTriggerEventSubscriptionStatusPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.datafactory.inputs.GetTriggerEventSubscriptionStatusPlainArgs =
        com.pulumi.azurenative.datafactory.inputs.GetTriggerEventSubscriptionStatusPlainArgs.builder()
            .factoryName(factoryName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .triggerName(triggerName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTriggerEventSubscriptionStatusPlainArgs].
 */
@PulumiTagMarker
public class GetTriggerEventSubscriptionStatusPlainArgsBuilder internal constructor() {
    private var factoryName: String? = null

    private var resourceGroupName: String? = null

    private var triggerName: String? = null

    /**
     * @param value The factory name.
     */
    @JvmName("esourhftmumahvkq")
    public suspend fun factoryName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.factoryName = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("anqnjroosltivddn")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The trigger name.
     */
    @JvmName("qfocmimoyqqvmxad")
    public suspend fun triggerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.triggerName = mapped
    }

    internal fun build(): GetTriggerEventSubscriptionStatusPlainArgs =
        GetTriggerEventSubscriptionStatusPlainArgs(
            factoryName = factoryName ?: throw PulumiNullFieldException("factoryName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            triggerName = triggerName ?: throw PulumiNullFieldException("triggerName"),
        )
}
